/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JavaTypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.Types;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.Map;
import java.util.Set;

class StringParameterResolver {
    private final Map<TypeIdentifier, TypeRepresentation> typeRepresentations;
    private final JavaTypeAnalyzer javaTypeAnalyzer;

    StringParameterResolver(Map<TypeIdentifier, TypeRepresentation> typeRepresentations, JavaTypeAnalyzer javaTypeAnalyzer) {
        this.typeRepresentations = typeRepresentations;
        this.javaTypeAnalyzer = javaTypeAnalyzer;
    }

    void replaceParametersTypes(Set<MethodParameter> parameters) {
        parameters.forEach(p -> {
            if (this.isStringOrPrimitive(p.getType())) {
                return;
            }
            TypeIdentifier identifier = this.javaTypeAnalyzer.analyze(p.getType().getType());
            TypeRepresentation typeRepresentation = this.typeRepresentations.get(identifier);
            if (this.isEnum(typeRepresentation)) {
                return;
            }
            if (this.isCollection(typeRepresentation)) {
                TypeIdentifier componentType = typeRepresentation.getComponentType();
                if (this.isStringOrPrimitive(componentType) || this.isEnum(this.typeRepresentations.get(componentType))) {
                    return;
                }
                p.setType(this.javaTypeAnalyzer.analyze("Ljava/util/List<Ljava/lang/String;>;"));
                return;
            }
            p.setType(TypeIdentifier.ofType("Ljava/lang/String;"));
        });
    }

    private boolean isStringOrPrimitive(TypeIdentifier componentType) {
        return componentType.getType().equals("Ljava/lang/String;") || Types.PRIMITIVE_TYPES_ALL.contains(componentType.getType());
    }

    private boolean isEnum(TypeRepresentation typeRepresentation) {
        return typeRepresentation instanceof TypeRepresentation.EnumTypeRepresentation;
    }

    private boolean isCollection(TypeRepresentation typeRepresentation) {
        return typeRepresentation instanceof TypeRepresentation.CollectionTypeRepresentation;
    }
}

