/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend;

import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.Types;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentationVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class JsonRepresentationAppender
implements TypeRepresentationVisitor {
    private final StringBuilder builder;
    private final Map<TypeIdentifier, TypeRepresentation> representations;
    private Set<TypeIdentifier> visitedTypes = new HashSet<TypeIdentifier>();

    JsonRepresentationAppender(StringBuilder builder, Map<TypeIdentifier, TypeRepresentation> representations) {
        this.builder = builder;
        this.representations = representations;
    }

    @Override
    public void visit(TypeRepresentation.ConcreteTypeRepresentation representation) {
        if (representation.getProperties().isEmpty()) {
            this.builder.append(JsonRepresentationAppender.toPrimitiveType(representation.getIdentifier()));
        } else {
            this.builder.append('{');
            this.visitedTypes.add(representation.getIdentifier());
            representation.getProperties().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> {
                this.builder.append('\"').append((String)e.getKey()).append("\":");
                TypeRepresentation nestedRepresentation = this.representations.get(e.getValue());
                if (nestedRepresentation == null) {
                    this.builder.append(JsonRepresentationAppender.toPrimitiveType((TypeIdentifier)e.getValue()));
                } else if (this.visitedTypes.contains(e.getValue())) {
                    this.builder.append("{}");
                } else {
                    nestedRepresentation.accept(this);
                }
                this.builder.append(',');
            });
            this.visitedTypes.remove(representation.getIdentifier());
            this.builder.deleteCharAt(this.builder.length() - 1).append('}');
        }
    }

    @Override
    public void visitStart(TypeRepresentation.CollectionTypeRepresentation representation) {
        this.builder.append('[');
    }

    @Override
    public void visitEnd(TypeRepresentation.CollectionTypeRepresentation representation) {
        this.builder.append(']');
    }

    @Override
    public void visit(TypeRepresentation.EnumTypeRepresentation representation) {
        String values = '\"' + representation.getEnumValues().stream().sorted().collect(Collectors.joining("|")) + '\"';
        this.builder.append(values.length() == 2 ? "\"string\"" : values);
    }

    private static String toPrimitiveType(TypeIdentifier value) {
        String type = value.getType();
        if ("Ljava/lang/String;".equals(type)) {
            return "\"string\"";
        }
        if ("Ljava/lang/Boolean;".equals(type) || "Z".equals(type)) {
            return "false";
        }
        if (Types.INTEGER_TYPES.contains(type)) {
            return "0";
        }
        if (Types.DOUBLE_TYPES.contains(type)) {
            return "0.0";
        }
        return "{}";
    }
}

