/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.JsonRepresentationAppender;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public abstract class StringBackend
implements Backend {
    public static final String INLINE_PRETTIFY = "inlinePrettify";
    private static final String INLINE_PRETTIFY_DEFAULT = "true";
    private static final Pattern CLEAR_COMPONENT_TYPE = Pattern.compile("[+\\-]");
    protected final Lock lock = new ReentrantLock();
    protected StringBuilder builder;
    protected Resources resources;
    protected String projectName;
    protected String projectVersion;
    protected boolean prettify;

    @Override
    public void configure(Map<String, String> config) {
        this.prettify = Boolean.parseBoolean(config.getOrDefault(INLINE_PRETTIFY, INLINE_PRETTIFY_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] render(Project project) {
        this.lock.lock();
        try {
            this.initRender(project);
            String output = this.renderInternal();
            byte[] byArray = StringBackend.serialize(output);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initRender(Project project) {
        this.builder = new StringBuilder();
        this.resources = project.getResources();
        this.projectName = project.getName();
        this.projectVersion = project.getVersion();
    }

    private String renderInternal() {
        this.appendHeader();
        this.resources.getResources().stream().sorted().forEach(this::appendResource);
        return this.builder.toString();
    }

    private void appendHeader() {
        this.appendFirstLine();
        this.builder.append(this.projectVersion).append("\n\n");
    }

    private void appendResource(String resource) {
        this.resources.getMethods(resource).stream().sorted(Comparator.comparing(ResourceMethod::getMethod)).forEach(resourceMethod -> {
            this.appendMethod(this.resources.getBasePath(), resource, (ResourceMethod)resourceMethod);
            this.appendRequest((ResourceMethod)resourceMethod);
            this.appendResponse((ResourceMethod)resourceMethod);
            this.appendResourceEnd();
        });
    }

    protected abstract void appendFirstLine();

    protected abstract void appendMethod(String var1, String var2, ResourceMethod var3);

    protected abstract void appendRequest(ResourceMethod var1);

    protected abstract void appendResponse(ResourceMethod var1);

    protected void appendResourceEnd() {
    }

    protected String doVisit(TypeRepresentation typeRepresentation) {
        StringBuilder builder = new StringBuilder();
        JsonRepresentationAppender appender = new JsonRepresentationAppender(builder, this.resources.getTypeRepresentations());
        typeRepresentation.accept(appender);
        String json = builder.toString();
        return this.prettify ? this.format(json) : json;
    }

    protected String toReadableComponentType(TypeIdentifier componentType) {
        String type = componentType.getType();
        return JavaUtils.toReadableType(CLEAR_COMPONENT_TYPE.matcher(type).replaceAll(""));
    }

    private static byte[] serialize(String output) {
        return output.getBytes();
    }

    /*
     * Exception decompiling
     */
    private String format(String json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

