/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import java.util.Map;
import javax.json.JsonObject;

class DefinitionNameBuilder {
    DefinitionNameBuilder() {
    }

    String buildDefinitionName(String typeName, Map<String, Pair<String, JsonObject>> jsonDefinitions) {
        String definition = this.buildDefinitionName(typeName);
        if (this.isOnlyType(typeName, definition, jsonDefinitions)) {
            return definition;
        }
        if (!definition.matches("_\\d+$")) {
            return definition + "_2";
        }
        int separatorIndex = definition.lastIndexOf(95);
        int index = Integer.parseInt(definition.substring(separatorIndex + 1));
        return definition.substring(0, separatorIndex + 1) + (index + 1);
    }

    private String buildDefinitionName(String typeName) {
        if (this.isDynamicType(typeName)) {
            return this.buildDynamicName(typeName);
        }
        return this.buildJavaTypeName(typeName);
    }

    private boolean isDynamicType(String typeName) {
        return typeName.startsWith("$");
    }

    private String buildDynamicName(String typeName) {
        return "JsonObject" + this.extractDynamicSuffix(typeName);
    }

    private String extractDynamicSuffix(String typeName) {
        String id = typeName.substring("$".length());
        return "1".equals(id) ? "" : "_" + id;
    }

    private String buildJavaTypeName(String typeName) {
        return typeName.substring(typeName.lastIndexOf(47) + 1, typeName.length() - 1);
    }

    private boolean isOnlyType(String typeName, String definition, Map<String, Pair<String, JsonObject>> jsonDefinitions) {
        Pair<String, JsonObject> containedEntry = jsonDefinitions.get(definition);
        return containedEntry == null || containedEntry.getLeft() != null && containedEntry.getLeft().equals(typeName);
    }
}

