/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.methods;

import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MethodIdentifier {
    private final String containingClass;
    private final String methodName;
    private final String returnType;
    private final boolean staticMethod;
    private final List<String> parameters;

    private MethodIdentifier(String containingClass, String methodName, List<String> parameters, String returnType, boolean staticMethod) {
        Objects.requireNonNull(containingClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        this.containingClass = containingClass;
        this.methodName = methodName;
        this.returnType = returnType;
        this.staticMethod = staticMethod;
        this.parameters = parameters;
    }

    public String getSignature() {
        StringBuilder builder = new StringBuilder("(");
        this.parameters.forEach(builder::append);
        return builder.append(')').append(this.returnType).toString();
    }

    public String getContainingClass() {
        return this.containingClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodIdentifier that = (MethodIdentifier)o;
        if (this.staticMethod != that.staticMethod) {
            return false;
        }
        if (!this.containingClass.equals(that.containingClass)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (this.parameters.equals(that.parameters)) {
            return true;
        }
        if (this.parameters.size() == that.parameters.size()) {
            List erasedTypes = this.parameters.stream().map(JavaUtils::toClassName).collect(Collectors.toList());
            List erasedThatTypes = that.parameters.stream().map(JavaUtils::toClassName).collect(Collectors.toList());
            String erasedReturnType = JavaUtils.toClassName(this.returnType);
            String erasedThatReturnType = JavaUtils.toClassName(that.returnType);
            return erasedTypes.equals(erasedThatTypes) && erasedReturnType.equals(erasedThatReturnType);
        }
        return false;
    }

    public int hashCode() {
        int result = this.containingClass.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + (this.staticMethod ? 1 : 0);
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return "MethodIdentifier{containingClass='" + this.containingClass + '\'' + ", methodName='" + this.methodName + '\'' + ", returnType='" + this.returnType + '\'' + ", staticMethod=" + this.staticMethod + ", parameters=" + this.parameters + '}';
    }

    public static MethodIdentifier of(String containingClass, String methodName, String signature, boolean staticMethod) {
        String returnType = JavaUtils.getReturnType(signature);
        List<String> parameters = JavaUtils.getParameters(signature);
        return new MethodIdentifier(containingClass, methodName, parameters, returnType, staticMethod);
    }

    public static MethodIdentifier ofNonStatic(String containingClass, String methodName, String returnType, String ... parameterTypes) {
        return MethodIdentifier.of(containingClass, methodName, returnType, false, parameterTypes);
    }

    public static MethodIdentifier ofStatic(String containingClass, String methodName, String returnType, String ... parameterTypes) {
        return MethodIdentifier.of(containingClass, methodName, returnType, true, parameterTypes);
    }

    private static MethodIdentifier of(String containingClass, String methodName, String returnType, boolean staticMethod, String[] parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return new MethodIdentifier(containingClass, methodName, Arrays.asList(parameterTypes), returnType, staticMethod);
    }
}

