/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Resources {
    private Map<String, Set<ResourceMethod>> resources = new HashMap<String, Set<ResourceMethod>>();
    private final Map<TypeIdentifier, TypeRepresentation> typeRepresentations = new HashMap<TypeIdentifier, TypeRepresentation>();
    private String basePath;

    public void addMethod(String resource, ResourceMethod method) {
        this.resources.putIfAbsent(resource, new HashSet());
        this.resources.get(resource).add(method);
    }

    public Set<String> getResources() {
        return Collections.unmodifiableSet(this.resources.keySet());
    }

    public Set<ResourceMethod> getMethods(String resource) {
        return Collections.unmodifiableSet(this.resources.get(resource));
    }

    public boolean isEmpty() {
        return this.resources.isEmpty() || this.resources.values().stream().allMatch(Set::isEmpty);
    }

    public void consolidateMultiplePaths() {
        Map<String, Set<ResourceMethod>> oldResources = this.resources;
        this.resources = new HashMap<String, Set<ResourceMethod>>();
        oldResources.keySet().forEach(s -> this.consolidateMultipleMethodsForSamePath((String)s, (Set)oldResources.get(s)));
    }

    private void consolidateMultipleMethodsForSamePath(String path, Set<ResourceMethod> resourceMethods) {
        resourceMethods.stream().collect(Collectors.groupingBy(m -> m.getMethod().toString().toLowerCase(), Collectors.reducing(new ResourceMethod(), ResourceMethod::combine))).forEach((k, v) -> this.addMethod(path, (ResourceMethod)v));
    }

    public Map<TypeIdentifier, TypeRepresentation> getTypeRepresentations() {
        return this.typeRepresentations;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Resources that = (Resources)object;
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        if (!this.typeRepresentations.equals(that.typeRepresentations)) {
            return false;
        }
        return !(this.basePath == null ? that.basePath != null : !this.basePath.equals(that.basePath));
    }

    public int hashCode() {
        int result = this.resources.hashCode();
        result = 31 * result + this.typeRepresentations.hashCode();
        result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Resources{resources=" + this.resources + ", typeRepresentations=" + this.typeRepresentations + ", basePath='" + this.basePath + '\'' + '}';
    }
}

