/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.messages;

import com.google.auto.value.AutoValue;
import com.segment.analytics.gson.AutoGson;
import com.segment.analytics.messages.AutoValue_GroupMessage;
import com.segment.analytics.messages.ImmutableMap;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

@AutoGson
@AutoValue
public abstract class GroupMessage
implements Message {
    public static Builder builder(String groupId) {
        return new Builder(groupId);
    }

    public abstract String groupId();

    @Nullable
    public abstract Map<String, ?> traits();

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends MessageBuilder<GroupMessage, Builder> {
        private String groupId;
        private Map<String, ?> traits;

        private Builder(GroupMessage group) {
            super(group);
            this.groupId = group.groupId();
            this.traits = group.traits();
        }

        private Builder(String groupId) {
            super(Message.Type.group);
            if (Builder.isNullOrEmpty(groupId)) {
                throw new IllegalArgumentException("groupId cannot be null or empty.");
            }
            this.groupId = groupId;
        }

        public Builder traits(Map<String, ?> traits) {
            if (traits == null) {
                throw new NullPointerException("Null traits");
            }
            this.traits = ImmutableMap.copyOf(traits);
            return this;
        }

        @Override
        protected GroupMessage realBuild(Message.Type type, String messageId, Date sentAt, Date timestamp, Map<String, ?> context, String anonymousId, String userId, Map<String, Object> integrations) {
            return new AutoValue_GroupMessage(type, messageId, sentAt, timestamp, context, anonymousId, userId, integrations, this.groupId, this.traits);
        }

        @Override
        Builder self() {
            return this;
        }
    }
}

