/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.im4java;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.annotation.CheckForNull;

public class GMOperation
extends org.im4java.core.GMOperation {
    public GMOperation limitThreads(int threadsPerProcess) {
        LinkedList args = this.getCmdArgs();
        args.add("-limit");
        args.add("threads");
        args.add(Integer.toString(threadsPerProcess));
        return this;
    }

    public GMOperation resize(int width, int height, Collection<GeometryAnnotation> annotations) {
        LinkedList args = this.getCmdArgs();
        args.add("-resize");
        args.add(GMOperation.resample(width, height, annotations));
        return this;
    }

    public GMOperation scale(int width, int height, Collection<GeometryAnnotation> annotations) {
        LinkedList args = this.getCmdArgs();
        args.add("-scale");
        args.add(GMOperation.resample(width, height, annotations));
        return this;
    }

    public GMOperation rotate(double degrees, RotationAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Rotation annotation must be defined");
        }
        LinkedList args = this.getCmdArgs();
        args.add("-rotate");
        args.add(String.format(Locale.ENGLISH, "%.1f%s", degrees, annotation.asAnnotation()));
        return this;
    }

    public GMOperation gravity(Gravity value) {
        if (value == null) {
            throw new IllegalArgumentException("Gravity value must be defined");
        }
        this.gravity(value.toString());
        return this;
    }

    public GMOperation grayscale(int depth) {
        this.type("Grayscale");
        this.depth(depth);
        return this;
    }

    public GMOperation stripProfiles() {
        LinkedList args = this.getCmdArgs();
        args.add("+profile");
        args.add("*");
        return this;
    }

    public GMOperation font(String style, int size, String color) {
        if (GMOperation.isBlank(style)) {
            throw new IllegalArgumentException("Text font style must be defined");
        }
        if (GMOperation.isBlank(color)) {
            throw new IllegalArgumentException("Text font color must be defined");
        }
        this.font(style);
        this.pointsize(size);
        this.fill(color);
        return this;
    }

    public GMOperation drawText(String text, int offsetX, int offsetY) {
        if (GMOperation.isBlank(text)) {
            throw new IllegalArgumentException("Text string must be defined");
        }
        this.draw(String.format(Locale.ENGLISH, "text %d %d '%s'", offsetX, offsetY, text));
        return this;
    }

    public GMOperation source(File file, @CheckForNull Integer width, @CheckForNull Integer height) throws IOException {
        if (file != null && !file.exists()) {
            throw new IOException("Source file '" + file + "' does not exist");
        }
        if (width != null && height != null && width > 0 && height > 0) {
            this.size(width, height);
        }
        return this.addImage(file);
    }

    public GMOperation addImage(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must be defined");
        }
        this.getCmdArgs().add(file.getPath());
        return this;
    }

    public GMOperation addRawArg(String arg) {
        this.getCmdArgs().add(arg);
        return this;
    }

    public GMOperation quality(double quality) {
        LinkedList args = this.getCmdArgs();
        args.add("-quality");
        args.add(Double.toString(quality));
        return this;
    }

    private static String resample(int width, int height, Collection<GeometryAnnotation> annotations) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Target height and width both should be greater than zero");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Geometry annotation(s) must be defined");
        }
        GeometryAnnotation.validate(annotations);
        StringBuilder buf = new StringBuilder();
        buf.append(width).append('x').append(height);
        for (GeometryAnnotation entry : annotations) {
            buf.append(entry.asAnnotation());
        }
        return buf.toString();
    }

    private static boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public static enum GeometryAnnotation {
        FillUsingAspectRatio("^"),
        FitUsingAspectRatio(""),
        ForceDimensions("!"),
        DimensionsAsPercentages("%"),
        DownsizeOnly(">"),
        UpsizeOnly("<");

        private final String annotation;

        private GeometryAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public String asAnnotation() {
            return this.annotation;
        }

        static void validate(Collection<GeometryAnnotation> used) {
            GeometryAnnotation.throwMutuallyExclusiveException(used, false, EnumSet.of(DownsizeOnly, UpsizeOnly));
            GeometryAnnotation.throwMutuallyExclusiveException(used, true, EnumSet.of(FillUsingAspectRatio, FitUsingAspectRatio, ForceDimensions));
        }

        private static void throwMutuallyExclusiveException(Collection<GeometryAnnotation> used, boolean shouldHaveAtLeastOne, Collection<GeometryAnnotation> mutuallyExclusive) {
            EnumSet<GeometryAnnotation> matched = EnumSet.copyOf(used);
            matched.retainAll(mutuallyExclusive);
            if (matched.size() > 1) {
                throw new IllegalArgumentException("Geometry annotations " + GeometryAnnotation.join(matched, "and") + "are mutually exclusive");
            }
            if (shouldHaveAtLeastOne && matched.size() != 1) {
                throw new IllegalArgumentException("One of the following geometry annotations must be used: " + GeometryAnnotation.join(mutuallyExclusive, "or"));
            }
        }

        private static String join(Collection<?> set, String andOr) {
            StringBuffer buf = new StringBuffer();
            Iterator<?> i = set.iterator();
            for (int n = set.size() - 2; n > 0; --n) {
                buf.append(i.next()).append(", ");
            }
            buf.append(i.next()).append(' ').append(andOr).append(' ').append(i.next());
            return buf.toString();
        }
    }

    public static enum Gravity {
        NorthWest,
        North,
        NorthEast,
        West,
        Center,
        East,
        SouthWest,
        South,
        SouthEast;

    }

    public static enum RotationAnnotation {
        Always(""),
        WidthExceedsHeightOnly(">"),
        HeightExceedsWidthOnly("<");

        private final String annotation;

        private RotationAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public String asAnnotation() {
            return this.annotation;
        }
    }
}

