/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scapegoat.io;

import com.sksamuel.scapegoat.Feedback;
import com.sksamuel.scapegoat.Level;
import com.sksamuel.scapegoat.Levels$Error$;
import com.sksamuel.scapegoat.Levels$Info$;
import com.sksamuel.scapegoat.Levels$Warning$;
import com.sksamuel.scapegoat.io.ReportWriter;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scapegoat.xml.Elem;
import scapegoat.xml.EntityRef;
import scapegoat.xml.MetaData;
import scapegoat.xml.Node;
import scapegoat.xml.NodeBuffer;
import scapegoat.xml.Null$;
import scapegoat.xml.Text;
import scapegoat.xml.TopScope$;
import scapegoat.xml.Unparsed$;
import scapegoat.xml.UnprefixedAttribute;

public final class HtmlReportWriter$
implements ReportWriter {
    public static HtmlReportWriter$ MODULE$;
    private final String css;

    static {
        new HtmlReportWriter$();
    }

    @Override
    public File write(File targetDir, Feedback feedback) {
        return ReportWriter.write$(this, targetDir, feedback);
    }

    @Override
    public String fileName() {
        return "scapegoat.html";
    }

    private String css() {
        return this.css;
    }

    /*
     * WARNING - void declaration
     */
    private Elem header() {
        void var1_1;
        void var3_3;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(new Text("Scapegoat Inspection Reporter"));
        $buf.$amp$plus(new Elem(null, "title", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var2_2));
        $buf.$amp$plus(Unparsed$.MODULE$.apply("<link href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css\" rel=\"stylesheet\">"));
        $buf.$amp$plus(Unparsed$.MODULE$.apply("<link href='https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700,300italic,400italic,500italic,700italic' rel='stylesheet' type='text/css'>"));
        $buf.$amp$plus(Unparsed$.MODULE$.apply("<link href='https://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800' rel='stylesheet' type='text/css'>"));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(new Text("\n         "));
        $buf3.$amp$plus(this.css());
        $buf3.$amp$plus(new Text("\n       "));
        $buf.$amp$plus(new Elem(null, "style", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var3_3));
        $buf.$amp$plus(new Text("\n    "));
        return new Elem(null, "head", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Elem body(Feedback reporter) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(new Text("Scapegoat Inspections"));
        $buf.$amp$plus(new Elem(null, "h1", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var3_3));
        $buf.$amp$plus(new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(new Text("\n        Errors\n        "));
        $buf3.$amp$plus(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Error$.MODULE$).size())).toString());
        $buf3.$amp$plus(new Text("\n        Warnings\n        "));
        $buf3.$amp$plus(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Warning$.MODULE$).size())).toString());
        $buf3.$amp$plus(new Text("\n        Infos\n        "));
        $buf3.$amp$plus(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Info$.MODULE$).size())).toString());
        $buf3.$amp$plus(new Text("\n      "));
        $buf.$amp$plus(new Elem(null, "h3", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)$buf3));
        $buf.$amp$plus(this.warnings(reporter));
        $buf.$amp$plus(new Text("\n    "));
        return new Elem(null, "body", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var2_2);
    }

    private Seq<Elem> warnings(Feedback reporter) {
        return (Seq)reporter.warningsWithMinimalLevel().map((Function1 & Serializable & scala.Serializable)warning -> {
            Object object;
            Elem elem;
            String source = new StringBuilder(1).append(warning.sourceFileNormalized()).append(":").append(warning.line()).toString();
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq<Node>)new Text("warning"), $md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(new Text("\n          "));
            MetaData $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq<Node>)new Text("source"), $md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus(new Text("\n            "));
            $buf2.$amp$plus(source);
            $buf2.$amp$plus(new Text("\n          "));
            $buf.$amp$plus(new Elem(null, "div", $md2, TopScope$.MODULE$, false, (Seq<Node>)$buf2));
            $buf.$amp$plus(new Text("\n          "));
            MetaData $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", (Seq<Node>)new Text("title"), $md3);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(new Text("\n            "));
            Level level = warning.level();
            if (Levels$Info$.MODULE$.equals(level)) {
                MetaData $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("class", (Seq<Node>)new Text("label label-info"), $md4);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus(new Text("Info"));
                elem = new Elem(null, "span", $md4, TopScope$.MODULE$, false, (Seq<Node>)$buf4);
            } else if (Levels$Warning$.MODULE$.equals(level)) {
                MetaData $md5 = Null$.MODULE$;
                $md5 = new UnprefixedAttribute("class", (Seq<Node>)new Text("label label-warning"), $md5);
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus(new Text("Warning"));
                elem = new Elem(null, "span", $md5, TopScope$.MODULE$, false, (Seq<Node>)$buf5);
            } else if (Levels$Error$.MODULE$.equals(level)) {
                MetaData $md6 = Null$.MODULE$;
                $md6 = new UnprefixedAttribute("class", (Seq<Node>)new Text("label label-danger"), $md6);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus(new Text("Error"));
                elem = new Elem(null, "span", $md6, TopScope$.MODULE$, false, (Seq<Node>)$buf6);
            } else {
                throw new MatchError((Object)level);
            }
            $buf3.$amp$plus(elem);
            $buf3.$amp$plus(new EntityRef("nbsp"));
            $buf3.$amp$plus(warning.text());
            $buf3.$amp$plus(new EntityRef("nbsp"));
            $buf3.$amp$plus(new Text(" "));
            MetaData $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq<Node>)new Text("inspection"), $md7);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus(new Text("\n            "));
            $buf7.$amp$plus(warning.inspection());
            $buf7.$amp$plus(new Text("\n          "));
            $buf3.$amp$plus(new Elem(null, "span", $md7, TopScope$.MODULE$, false, (Seq<Node>)$buf7));
            $buf3.$amp$plus(new Text("\n          "));
            $buf.$amp$plus(new Elem(null, "div", $md3, TopScope$.MODULE$, false, (Seq<Node>)$buf3));
            $buf.$amp$plus(new Text("\n          "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus(new Text("\n            "));
            $buf8.$amp$plus(warning.explanation());
            $buf8.$amp$plus(new Text("\n          "));
            $buf.$amp$plus(new Elem(null, "div", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)$buf8));
            Option<String> option = warning.snippet();
            if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String snippet = (String)some.value();
                MetaData $md8 = Null$.MODULE$;
                $md8 = new UnprefixedAttribute("class", (Seq<Node>)new Text("snippet"), $md8);
                NodeBuffer $buf9 = new NodeBuffer();
                $buf9.$amp$plus(new Text("\n              "));
                $buf9.$amp$plus(snippet);
                $buf9.$amp$plus(new Text("\n            "));
                object = new Elem(null, "div", $md8, TopScope$.MODULE$, false, (Seq<Node>)$buf9);
            } else {
                throw new MatchError(option);
            }
            $buf.$amp$plus(object);
            $buf.$amp$plus(new Text("\n        "));
            return new Elem(null, "div", $md, TopScope$.MODULE$, false, (Seq<Node>)$buf);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private Elem toHTML(Feedback reporter) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n      "));
        $buf.$amp$plus(this.header());
        $buf.$amp$plus(this.body(reporter));
        $buf.$amp$plus(new Text("\n    "));
        return new Elem(null, "html", Null$.MODULE$, TopScope$.MODULE$, false, (Seq<Node>)var2_2);
    }

    @Override
    public String generate(Feedback feedback) {
        return this.toHTML(feedback).toString();
    }

    private HtmlReportWriter$() {
        MODULE$ = this;
        ReportWriter.$init$(this);
        this.css = new StringOps(Predef$.MODULE$.augmentString("\n      |      body {\n      |        font-family: 'Ubuntu', sans-serif;\n      |        padding: 0 15px;\n      |      }\n      |\n      |      h1 {\n      |      \tcolor: #515151;\n      |      \tfont-weight: 700;\n      |      }\n      |\n      |      h3 {\n      |      \tcolor: #8a8a8a;\n      |      \tfont-weight: 400;\n      |      }\n      |\n      |      .warning {\n      |      \t  background :#F1F3F2;\n      |      \t  border-bottom-left-radius: 6px;\n      |\t\t      border-bottom-right-radius: 6px;\n      |      \t  margin-bottom: 3px;\n      |      \t  padding: 12px;\n      |      }\n      |\n      |      .title {\n      |      \tcolor: #616161;\n      |      \tfont-size: 16px;\n      |      }\n      |\n      |      .source {\n      |        float: right;\n      |      \t font-style: italic;\n      |        color: #868686;\n      |      }\n      |\n      |      .snippet {\n      |        padding-top: 8px;\n      |        color: #0C0C0C;\n      |        font-weight: 300;\n      |        font-size: 12px;\n      |      }\n      |\n      |      .inspection {\n      |        padding-left: 10px;\n      |        font-style:italic;\n      |        color: #969696;\n      |        font-size: 12px;\n      |      }\n      |\n      |\n    ")).stripMargin();
    }
}

