/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rate_limits.metrics;

import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.RequestStats;
import com.slack.api.util.thread.ExecutorServiceProvider;
import java.util.Map;

public interface MetricsDatastore {
    public static final String DEFAULT_SINGLETON_EXECUTOR_NAME = "DEFAULT_SINGLETON_EXECUTOR";

    default public int getNumberOfNodes() {
        return 1;
    }

    public Map<String, Map<String, RequestStats>> getAllStats();

    default public RequestStats getStats(String teamId) {
        return this.getStats(DEFAULT_SINGLETON_EXECUTOR_NAME, teamId);
    }

    public RequestStats getStats(String var1, String var2);

    public void incrementAllCompletedCalls(String var1, String var2, String var3);

    public void incrementSuccessfulCalls(String var1, String var2, String var3);

    public void incrementUnsuccessfulCalls(String var1, String var2, String var3);

    public void incrementFailedCalls(String var1, String var2, String var3);

    public void updateCurrentQueueSize(String var1, String var2, String var3);

    public void setCurrentQueueSize(String var1, String var2, String var3, Integer var4);

    public void updateNumberOfLastMinuteRequests(String var1, String var2, String var3);

    public Integer getNumberOfLastMinuteRequests(String var1, String var2, String var3);

    public void setNumberOfLastMinuteRequests(String var1, String var2, String var3, Integer var4);

    public Long getRateLimitedMethodRetryEpochMillis(String var1, String var2, String var3);

    public void setRateLimitedMethodRetryEpochMillis(String var1, String var2, String var3, Long var4);

    public void addToLastMinuteRequests(String var1, String var2, String var3, Long var4);

    public LastMinuteRequests getLastMinuteRequests(String var1, String var2, String var3);

    public void addToWaitingMessageIds(String var1, String var2, String var3, String var4);

    public void deleteFromWaitingMessageIds(String var1, String var2, String var3, String var4);

    public ExecutorServiceProvider getExecutorServiceProvider();

    public void setExecutorServiceProvider(ExecutorServiceProvider var1);

    public boolean isTraceMode();

    public void setTraceMode(boolean var1);

    public boolean isStatsEnabled();

    public void setStatsEnabled(boolean var1);

    public long getRateLimiterBackgroundJobIntervalMillis();

    public void setRateLimiterBackgroundJobIntervalMillis(long var1);
}

