/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim.impl;

import com.slack.api.RequestConfigurator;
import com.slack.api.SlackConfig;
import com.slack.api.methods.impl.TeamIdCache;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.scim.SCIMApiException;
import com.slack.api.scim.SCIMApiRequest;
import com.slack.api.scim.SCIMClient;
import com.slack.api.scim.SCIMConfig;
import com.slack.api.scim.SCIMEndpointName;
import com.slack.api.scim.request.GroupsCreateRequest;
import com.slack.api.scim.request.GroupsDeleteRequest;
import com.slack.api.scim.request.GroupsPatchRequest;
import com.slack.api.scim.request.GroupsReadRequest;
import com.slack.api.scim.request.GroupsSearchRequest;
import com.slack.api.scim.request.GroupsUpdateRequest;
import com.slack.api.scim.request.ServiceProviderConfigsGetRequest;
import com.slack.api.scim.request.UsersCreateRequest;
import com.slack.api.scim.request.UsersDeleteRequest;
import com.slack.api.scim.request.UsersPatchRequest;
import com.slack.api.scim.request.UsersReadRequest;
import com.slack.api.scim.request.UsersSearchRequest;
import com.slack.api.scim.request.UsersUpdateRequest;
import com.slack.api.scim.response.GroupsCreateResponse;
import com.slack.api.scim.response.GroupsDeleteResponse;
import com.slack.api.scim.response.GroupsPatchResponse;
import com.slack.api.scim.response.GroupsReadResponse;
import com.slack.api.scim.response.GroupsSearchResponse;
import com.slack.api.scim.response.GroupsUpdateResponse;
import com.slack.api.scim.response.ServiceProviderConfigsGetResponse;
import com.slack.api.scim.response.UsersCreateResponse;
import com.slack.api.scim.response.UsersDeleteResponse;
import com.slack.api.scim.response.UsersPatchResponse;
import com.slack.api.scim.response.UsersReadResponse;
import com.slack.api.scim.response.UsersSearchResponse;
import com.slack.api.scim.response.UsersUpdateResponse;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import okhttp3.Request;
import okhttp3.Response;

public class SCIMClientImpl
implements SCIMClient {
    private String endpointUrlPrefix = "https://api.slack.com/scim/v1/";
    private final SlackHttpClient slackHttpClient;
    private final String token;
    private final SCIMConfig config;
    private final String executorName;
    private final TeamIdCache teamIdCache;

    public SCIMClientImpl(SlackConfig config, SlackHttpClient slackHttpClient, TeamIdCache teamIdCache) {
        this(config, slackHttpClient, teamIdCache, null);
    }

    public SCIMClientImpl(SlackConfig config, SlackHttpClient slackHttpClient, TeamIdCache teamIdCache, String token) {
        this.slackHttpClient = slackHttpClient;
        this.token = token;
        this.config = config.getSCIMConfig();
        this.executorName = this.config.getExecutorName();
        this.teamIdCache = teamIdCache;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.endpointUrlPrefix;
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.endpointUrlPrefix = endpointUrlPrefix;
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(ServiceProviderConfigsGetRequest req) throws IOException, SCIMApiException {
        return this.doGet(SCIMEndpointName.getServiceProviderConfigs, this.endpointUrlPrefix + "ServiceProviderConfigs", null, this.getToken(req), ServiceProviderConfigsGetResponse.class);
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(RequestConfigurator<ServiceProviderConfigsGetRequest.ServiceProviderConfigsGetRequestBuilder> req) throws IOException, SCIMApiException {
        return this.getServiceProviderConfigs(req.configure(ServiceProviderConfigsGetRequest.builder()).build());
    }

    @Override
    public UsersSearchResponse searchUsers(UsersSearchRequest req) throws IOException, SCIMApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(SCIMEndpointName.searchUsers, this.getUsersResourceURL(), query, this.getToken(req), UsersSearchResponse.class);
    }

    @Override
    public UsersSearchResponse searchUsers(RequestConfigurator<UsersSearchRequest.UsersSearchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.searchUsers(req.configure(UsersSearchRequest.builder()).build());
    }

    @Override
    public UsersReadResponse readUser(UsersReadRequest req) throws IOException, SCIMApiException {
        return this.doGet(SCIMEndpointName.readUser, this.getUsersResourceURL() + "/" + req.getId(), null, this.getToken(req), UsersReadResponse.class);
    }

    @Override
    public UsersReadResponse readUser(RequestConfigurator<UsersReadRequest.UsersReadRequestBuilder> req) throws IOException, SCIMApiException {
        return this.readUser(req.configure(UsersReadRequest.builder()).build());
    }

    @Override
    public UsersCreateResponse createUser(UsersCreateRequest req) throws IOException, SCIMApiException {
        return this.doPost(SCIMEndpointName.createUser, this.getUsersResourceURL(), req.getUser(), this.getToken(req), UsersCreateResponse.class);
    }

    @Override
    public UsersCreateResponse createUser(RequestConfigurator<UsersCreateRequest.UsersCreateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.createUser(req.configure(UsersCreateRequest.builder()).build());
    }

    @Override
    public UsersPatchResponse patchUser(UsersPatchRequest req) throws IOException, SCIMApiException {
        return this.doPatch(SCIMEndpointName.patchUser, this.getUsersResourceURL() + "/" + req.getId(), req.getUser(), this.getToken(req), UsersPatchResponse.class);
    }

    @Override
    public UsersPatchResponse patchUser(RequestConfigurator<UsersPatchRequest.UsersPatchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.patchUser(req.configure(UsersPatchRequest.builder()).build());
    }

    @Override
    public UsersUpdateResponse updateUser(UsersUpdateRequest req) throws IOException, SCIMApiException {
        return this.doPut(SCIMEndpointName.updateUser, this.getUsersResourceURL() + "/" + req.getId(), req.getUser(), this.getToken(req), UsersUpdateResponse.class);
    }

    @Override
    public UsersUpdateResponse updateUser(RequestConfigurator<UsersUpdateRequest.UsersUpdateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.updateUser(req.configure(UsersUpdateRequest.builder()).build());
    }

    @Override
    public UsersDeleteResponse deleteUser(UsersDeleteRequest req) throws IOException, SCIMApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getUsersResourceURL() + "/" + req.getId());
        return this.doDelete(SCIMEndpointName.deleteUser, requestBuilder, UsersDeleteResponse.class);
    }

    @Override
    public UsersDeleteResponse deleteUser(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) throws IOException, SCIMApiException {
        return this.deleteUser(req.configure(UsersDeleteRequest.builder()).build());
    }

    @Override
    public GroupsSearchResponse searchGroups(GroupsSearchRequest req) throws IOException, SCIMApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(SCIMEndpointName.searchGroups, this.getGroupsResourceURL(), query, this.getToken(req), GroupsSearchResponse.class);
    }

    @Override
    public GroupsSearchResponse searchGroups(RequestConfigurator<GroupsSearchRequest.GroupsSearchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.searchGroups(req.configure(GroupsSearchRequest.builder()).build());
    }

    @Override
    public GroupsReadResponse readGroup(GroupsReadRequest req) throws IOException, SCIMApiException {
        return this.doGet(SCIMEndpointName.readGroup, this.getGroupsResourceURL() + "/" + req.getId(), null, this.getToken(req), GroupsReadResponse.class);
    }

    @Override
    public GroupsReadResponse readGroup(RequestConfigurator<GroupsReadRequest.GroupsReadRequestBuilder> req) throws IOException, SCIMApiException {
        return this.readGroup(req.configure(GroupsReadRequest.builder()).build());
    }

    @Override
    public GroupsCreateResponse createGroup(GroupsCreateRequest req) throws IOException, SCIMApiException {
        return this.doPost(SCIMEndpointName.createGroup, this.getGroupsResourceURL(), req.getGroup(), this.getToken(req), GroupsCreateResponse.class);
    }

    @Override
    public GroupsCreateResponse createGroup(RequestConfigurator<GroupsCreateRequest.GroupsCreateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.createGroup(req.configure(GroupsCreateRequest.builder()).build());
    }

    @Override
    public GroupsPatchResponse patchGroup(GroupsPatchRequest req) throws IOException, SCIMApiException {
        return this.doPatch(SCIMEndpointName.patchGroup, this.getGroupsResourceURL() + "/" + req.getId(), req.getGroup(), this.getToken(req), GroupsPatchResponse.class);
    }

    @Override
    public GroupsPatchResponse patchGroup(RequestConfigurator<GroupsPatchRequest.GroupsPatchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.patchGroup(req.configure(GroupsPatchRequest.builder()).build());
    }

    @Override
    public GroupsUpdateResponse updateGroup(GroupsUpdateRequest req) throws IOException, SCIMApiException {
        return this.doPut(SCIMEndpointName.updateGroup, this.getGroupsResourceURL() + "/" + req.getId(), req.getGroup(), this.getToken(req), GroupsUpdateResponse.class);
    }

    @Override
    public GroupsUpdateResponse updateGroup(RequestConfigurator<GroupsUpdateRequest.GroupsUpdateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.updateGroup(req.configure(GroupsUpdateRequest.builder()).build());
    }

    @Override
    public GroupsDeleteResponse deleteGroup(GroupsDeleteRequest req) throws IOException, SCIMApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getGroupsResourceURL() + "/" + req.getId());
        return this.doDelete(SCIMEndpointName.deleteGroup, requestBuilder, GroupsDeleteResponse.class);
    }

    @Override
    public GroupsDeleteResponse deleteGroup(RequestConfigurator<GroupsDeleteRequest.GroupsDeleteRequestBuilder> req) throws IOException, SCIMApiException {
        return this.deleteGroup(req.configure(GroupsDeleteRequest.builder()).build());
    }

    private String getToken(SCIMApiRequest req) {
        if (req.getToken() != null) {
            return req.getToken();
        }
        if (this.token != null) {
            return this.token;
        }
        throw new IllegalStateException("Slack OAuth token is missing! Set token in either SCIMClient or request object.");
    }

    private Request.Builder withAuthorizationHeader(Request.Builder req, String token) {
        return req.addHeader("Authorization", "Bearer " + token);
    }

    private String getUsersResourceURL() {
        return this.endpointUrlPrefix + "Users";
    }

    private String getGroupsResourceURL() {
        return this.endpointUrlPrefix + "Groups";
    }

    private String getEnterpriseIdForMetrics() {
        String enterpriseId = null;
        if (this.config.isStatsEnabled()) {
            enterpriseId = this.teamIdCache.lookupOrResolve(this.token);
        }
        return enterpriseId;
    }

    private <T> T handle(SCIMEndpointName name, Class<T> clazz, Function0<Response> performRequest) throws IOException, SCIMApiException {
        String enterpriseId = this.getEnterpriseIdForMetrics();
        MetricsDatastore datastore = this.config.getMetricsDatastore();
        try {
            Response response = (Response)performRequest.invoke();
            T result = this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
            if (enterpriseId != null) {
                datastore.incrementSuccessfulCalls(this.executorName, enterpriseId, name.name());
            }
            T t = result;
            return t;
        }
        catch (SCIMApiException e) {
            String retryAfterSeconds;
            if (enterpriseId != null) {
                datastore.incrementUnsuccessfulCalls(this.executorName, enterpriseId, name.name());
            }
            if (e.getResponse().code() == 429 && (retryAfterSeconds = e.getResponse().header("Retry-After")) != null) {
                long secondsToWait = Long.valueOf(retryAfterSeconds);
                long epochMillisToRetry = System.currentTimeMillis() + secondsToWait * 1000L;
                if (enterpriseId != null) {
                    datastore.setRateLimitedMethodRetryEpochMillis(this.executorName, enterpriseId, name.name(), epochMillisToRetry);
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (enterpriseId != null) {
                datastore.incrementFailedCalls(this.executorName, enterpriseId, name.name());
            }
            if (e.getCause() instanceof IOException) {
                IOException ioe = (IOException)e.getCause();
                throw ioe;
            }
            throw e;
        }
        finally {
            if (enterpriseId != null) {
                datastore.incrementAllCompletedCalls(this.executorName, enterpriseId, name.name());
                datastore.addToLastMinuteRequests(this.executorName, enterpriseId, name.name(), System.currentTimeMillis());
            }
        }
    }

    private <T> T doGet(SCIMEndpointName name, String url, Map<String, String> query, String token, Class<T> clazz) throws IOException, SCIMApiException {
        return this.handle(name, clazz, (Function0<Response>)((Function0)() -> {
            try {
                return this.slackHttpClient.get(url, query, token);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <T> T doPost(SCIMEndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        return this.handle(name, clazz, (Function0<Response>)((Function0)() -> {
            try {
                return this.slackHttpClient.postCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <T> T doPatch(SCIMEndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        return this.handle(name, clazz, (Function0<Response>)((Function0)() -> {
            try {
                return this.slackHttpClient.patchCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <T> T doPut(SCIMEndpointName name, String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        return this.handle(name, clazz, (Function0<Response>)((Function0)() -> {
            try {
                return this.slackHttpClient.putCamelCaseJsonBodyWithBearerHeader(url, token, body);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <T> T doDelete(SCIMEndpointName name, Request.Builder requestBuilder, Class<T> clazz) throws IOException, SCIMApiException {
        return this.handle(name, clazz, (Function0<Response>)((Function0)() -> {
            try {
                return this.slackHttpClient.delete(requestBuilder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <T> T parseCamelCaseJsonResponseAndRunListeners(Response response, Class<T> clazz) throws IOException, SCIMApiException {
        String body = response.body().string();
        try {
            if (response.isSuccessful()) {
                Object object = GsonFactory.createCamelCase(this.slackHttpClient.getConfig()).fromJson(body, clazz);
                return (T)object;
            }
            throw new SCIMApiException(this.slackHttpClient.getConfig(), response, body);
        }
        finally {
            this.slackHttpClient.runHttpResponseListeners(response, body);
        }
    }
}

