/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim2;

import com.slack.api.SlackConfig;
import com.slack.api.scim2.SCIM2ApiErrorResponse;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCIM2ApiException
extends Exception {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SCIM2ApiException.class);
    private final Response response;
    private final String responseBody;
    private final SCIM2ApiErrorResponse error;

    public SCIM2ApiException(Response response, String responseBody) {
        this(SlackConfig.DEFAULT, response, responseBody);
    }

    public SCIM2ApiException(SlackConfig config, Response response, String responseBody) {
        this(response, responseBody, SCIM2ApiException.parse(config, responseBody));
    }

    public SCIM2ApiException(Response response, String responseBody, SCIM2ApiErrorResponse error) {
        super(SCIM2ApiException.buildErrorMessage(response, error));
        this.response = response;
        this.responseBody = responseBody;
        this.error = error;
    }

    private static String buildErrorMessage(Response response, SCIM2ApiErrorResponse error) {
        String message = "status: " + response.code();
        if (error != null && error.getErrors() != null) {
            return message + ", description: " + error.getErrors().getDescription();
        }
        if (error != null && error.getDetail() != null) {
            return message + ", detail: " + error.getDetail();
        }
        return message + ", no response body";
    }

    private static SCIM2ApiErrorResponse parse(SlackConfig config, String responseBody) {
        SCIM2ApiErrorResponse parsedErrorResponse;
        block2: {
            parsedErrorResponse = null;
            try {
                parsedErrorResponse = (SCIM2ApiErrorResponse)GsonFactory.createCamelCase(config).fromJson(responseBody, SCIM2ApiErrorResponse.class);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                String responseToPrint = responseBody.length() > 1000 ? responseBody.subSequence(0, 1000) + " ..." : responseBody;
                log.debug("Failed to parse the error response body: {}", (Object)responseToPrint);
            }
        }
        return parsedErrorResponse;
    }

    @Generated
    public Response getResponse() {
        return this.response;
    }

    @Generated
    public String getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public SCIM2ApiErrorResponse getError() {
        return this.error;
    }

    @Override
    @Generated
    public String toString() {
        return "SCIM2ApiException(response=" + this.getResponse() + ", responseBody=" + this.getResponseBody() + ", error=" + this.getError() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCIM2ApiException)) {
            return false;
        }
        SCIM2ApiException other = (SCIM2ApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        SCIM2ApiErrorResponse this$error = this.getError();
        SCIM2ApiErrorResponse other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCIM2ApiException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        SCIM2ApiErrorResponse $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }
}

