/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

class DbCache
implements Iterable<Map.Entry<DatabaseId, DbInfo>> {
    private final EnvironmentImpl envImpl;
    private final Cleaner cleaner;
    private final long timoutMs;
    private long lastClearTime;
    private int lookups;
    private final Map<DatabaseId, DbInfo> cache = new HashMap<DatabaseId, DbInfo>();

    DbCache(EnvironmentImpl envImpl, Cleaner cleaner) {
        this.envImpl = envImpl;
        this.cleaner = cleaner;
        this.timoutMs = envImpl.getConfigManager().getDuration(EnvironmentParams.ENV_DB_CACHE_TIMEOUT);
        this.lastClearTime = System.currentTimeMillis();
    }

    DbInfo getDbInfo(DatabaseId dbId) {
        DbInfo info = this.cache.get(dbId);
        if (info != null) {
            return info;
        }
        return this.getDbImpl(dbId);
    }

    DbInfo getDbImpl(DatabaseId id) {
        DbInfo info = this.cache.get(id);
        if (info == null) {
            info = new DbInfo();
            this.cache.put(id, info);
        }
        if (info.dbImpl == null && !info.deleted && !info.deleting) {
            DatabaseImpl db = this.envImpl.getDbTree().getDb(id, this.cleaner.lockTimeout);
            if (db == null) {
                info.deleted = true;
            } else {
                info.dbImpl = db;
                info.dups = db.getSortedDuplicates();
                info.internal = db.getDbType().isInternal();
                info.isLNImmediatelyObsolete = db.isLNImmediatelyObsolete();
                info.name = db.getName();
                info.deleting = db.isDeleting();
            }
            ++this.lookups;
        }
        return info;
    }

    @Override
    public @NonNull Iterator<Map.Entry<DatabaseId, DbInfo>> iterator() {
        return this.cache.entrySet().iterator();
    }

    int getLookups() {
        return this.lookups;
    }

    void releaseDbImpls() {
        for (DbInfo info : this.cache.values()) {
            this.releaseDbImpl(info);
        }
    }

    void releaseDbImpl(DbInfo info) {
        if (info.dbImpl != null) {
            this.envImpl.getDbTree().releaseDb(info.dbImpl);
            info.dbImpl = null;
        }
    }

    void clearCachePeriodically() {
        long now = System.currentTimeMillis();
        if (now >= this.lastClearTime + this.timoutMs) {
            this.releaseDbImpls();
            this.lastClearTime = now;
        }
    }

    static class DbInfo {
        DatabaseImpl dbImpl;
        boolean dups;
        boolean internal;
        boolean isLNImmediatelyObsolete;
        String name;
        boolean deleted;
        boolean deleting;

        DbInfo() {
        }
    }
}

