/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.stream.ArbiterFeederStatDefinition;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ArbiterFeederSource
implements FeederSource {
    private final BlockingQueue<LogItem> queue;
    private final EnvironmentImpl envImpl;
    private final StatGroup stats;
    private final LongStat nQueueFull;

    public ArbiterFeederSource(EnvironmentImpl envImpl) throws DatabaseException {
        int queueSize = envImpl.getConfigManager().getInt(RepParams.ARBITER_OUTPUT_QUEUE_SIZE);
        this.queue = new ArrayBlockingQueue<LogItem>(queueSize);
        this.envImpl = envImpl;
        this.stats = new StatGroup("ArbiterFeeder", "ArbiterFeeder statistics");
        this.nQueueFull = new LongStat(this.stats, ArbiterFeederStatDefinition.QUEUE_FULL);
    }

    public void addCommit(LogItem commitItem) {
        if (!this.queue.offer(commitItem)) {
            this.nQueueFull.increment();
            try {
                LogItem queuedItem = (LogItem)this.queue.remove();
                VLSN vlsn = commitItem.header.getVLSN();
                if (queuedItem.header.getVLSN().compareTo(vlsn) > 0) {
                    commitItem = queuedItem;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.queue.offer(commitItem);
        }
    }

    @Override
    public void shutdown(EnvironmentImpl envImpl) {
    }

    @Override
    public OutputWireRecord getWireRecord(VLSN vlsn, int waitTime) throws DatabaseException, InterruptedException, IOException {
        LogItem commitItem = this.queue.poll(waitTime, TimeUnit.MILLISECONDS);
        if (commitItem != null) {
            return new OutputWireRecord(this.envImpl, commitItem);
        }
        return null;
    }

    public StatGroup loadStats(StatsConfig config) throws DatabaseException {
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        return copyStats;
    }

    @Override
    public String dumpState() {
        return null;
    }
}

