/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.subscription.SubscriptionAuthHandler;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.utilint.ServiceHandshake;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClientAuthMethod
implements ServiceHandshake.AuthenticationMethod {
    private final SubscriptionAuthHandler clientAuthHandler;

    ClientAuthMethod(SubscriptionAuthHandler clientAuthHandler) {
        this.clientAuthHandler = clientAuthHandler;
    }

    @Override
    public String getMechanismName() {
        return "SubscriptionTokenAuth";
    }

    @Override
    public ServiceHandshake.ClientInitOp getClientOp(ServiceHandshake.ClientHandshake initState, String ignoredParams) {
        return new ClientTokenOp(initState, this.clientAuthHandler);
    }

    @Override
    public ServiceHandshake.ServerInitOp getServerOp(ServiceHandshake.ServerHandshake initState) {
        return new ServerTokenOp(initState);
    }

    @Override
    public String getServerParams() {
        return "";
    }

    class ServerTokenOp
    extends ServiceHandshake.ServerInitOp {
        ServerTokenOp(ServiceHandshake.ServerHandshake initState) {
            super(initState);
        }

        @Override
        public ServiceHandshake.InitResult processOp(DataChannel channel) throws IOException {
            return ServiceHandshake.InitResult.FAIL;
        }
    }

    static class ClientTokenOp
    extends ServiceHandshake.ClientInitOp {
        private final SubscriptionAuthHandler auth;

        ClientTokenOp(ServiceHandshake.ClientHandshake initState, SubscriptionAuthHandler auth) {
            super(initState);
            this.auth = auth;
        }

        @Override
        public ServiceHandshake.InitResult processOp(ServiceHandshake.IOAdapter ioAdapter) throws IOException {
            byte[] token = this.auth.getToken();
            if (token == null || token.length == 0) {
                throw new IOException("Token cannot be null or empty");
            }
            ByteBuffer szBuf = ByteBuffer.allocate(4);
            LogUtils.writeInt(szBuf, token.length);
            ioAdapter.write(szBuf.array());
            ByteBuffer tokenBuf = ByteBuffer.allocate(token.length);
            LogUtils.writeBytesNoLength(tokenBuf, token);
            ioAdapter.write(tokenBuf.array());
            byte[] responseByte = new byte[1];
            int result = ioAdapter.read(responseByte);
            if (result < 0) {
                throw new IOException("No service authenticate response byte: " + result);
            }
            ServiceDispatcher.Response response = ServiceDispatcher.Response.get(responseByte[0]);
            if (response == null) {
                throw new IOException("Unexpected read response byte: " + responseByte[0]);
            }
            this.setResponse(response);
            return ServiceHandshake.InitResult.DONE;
        }
    }
}

