/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LatencyPercentile;
import com.sleepycat.je.utilint.MapStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;
import java.util.Map;

public class LatencyPercentileMapStat
extends MapStat<Long, LatencyPercentile> {
    private static final long serialVersionUID = 1L;
    private final float percentile;
    private final int maxTrackedLatencyMillis;

    public LatencyPercentileMapStat(StatGroup group, StatDefinition definition, float percentile) {
        this(group, definition, percentile, 1000);
    }

    public LatencyPercentileMapStat(StatGroup group, StatDefinition definition, float percentile, int maxTrackedLatencyMillis) {
        super(group, definition);
        if (definition.getType() != StatDefinition.StatType.INCREMENTAL) {
            throw new IllegalArgumentException("The stat type must be INCREMENTAL, found: " + (Object)((Object)definition.getType()));
        }
        if ((double)percentile < 0.0 || (double)percentile > 1.0) {
            throw new IllegalArgumentException("Percentile must not be less than 0.0 or greater than 1.0: " + percentile);
        }
        this.percentile = percentile;
        if (maxTrackedLatencyMillis < 0) {
            throw new IllegalArgumentException("The maxTrackedLatencyMillis must not be negative: " + maxTrackedLatencyMillis);
        }
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
    }

    private LatencyPercentileMapStat(LatencyPercentileMapStat other) {
        super(other);
        this.percentile = other.percentile;
        this.maxTrackedLatencyMillis = other.maxTrackedLatencyMillis;
    }

    public synchronized LatencyPercentile createStat(String key) {
        assert (key != null);
        LatencyPercentile stat = new LatencyPercentile(this.definition.getName() + ":" + key, this.percentile, this.maxTrackedLatencyMillis);
        this.statMap.put(key, stat);
        return stat;
    }

    @Override
    public LatencyPercentileMapStat copy() {
        return new LatencyPercentileMapStat(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatencyPercentileMapStat computeInterval(Stat<String> base) {
        LatencyPercentileMapStat result;
        if (!(base instanceof LatencyPercentileMapStat)) {
            throw new IllegalArgumentException("Base stat must be a LatencyPercentileMapStat, found: " + base);
        }
        LatencyPercentileMapStat other = (LatencyPercentileMapStat)base.copy();
        LatencyPercentileMapStat latencyPercentileMapStat = result = this.copy();
        synchronized (latencyPercentileMapStat) {
            LatencyPercentileMapStat latencyPercentileMapStat2 = other;
            synchronized (latencyPercentileMapStat2) {
                Iterator i = result.statMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    String key = (String)e.getKey();
                    LatencyPercentile stat = (LatencyPercentile)e.getValue();
                    LatencyPercentile otherStat = (LatencyPercentile)other.statMap.get(key);
                    if (otherStat != null) {
                        stat.updateInterval(otherStat);
                        continue;
                    }
                    i.remove();
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void negate() {
        for (LatencyPercentile latency : this.statMap.values()) {
            latency.negate();
        }
    }
}

