/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.utilint.FormatUtil;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;

public class StatsAccumulator
implements TreeWalkerStatsAccumulator {
    private final Set<Long> inNodeIdsSeen = new HashSet<Long>();
    private final Set<Long> binNodeIdsSeen = new HashSet<Long>();
    private long[] insSeenByLevel = null;
    private long[] binsSeenByLevel = null;
    private long[] binEntriesHistogram = null;
    private long lnCount = 0L;
    private long deletedLNCount = 0L;
    private int mainTreeMaxDepth = 0;
    public PrintStream progressStream;
    int progressInterval;
    private static final int MAX_LEVELS = 100;

    public StatsAccumulator(PrintStream progressStream, int progressInterval) {
        this.progressStream = progressStream;
        this.progressInterval = progressInterval;
        this.insSeenByLevel = new long[100];
        this.binsSeenByLevel = new long[100];
        this.binEntriesHistogram = new long[10];
    }

    public void verifyNode(Node node) {
    }

    @Override
    public void processIN(IN node, Long nid, int level) {
        if (this.inNodeIdsSeen.add(nid)) {
            this.tallyLevel(level, this.insSeenByLevel);
            this.verifyNode(node);
        }
    }

    @Override
    public void processBIN(BIN node, Long nid, int level) {
        if (this.binNodeIdsSeen.add(nid)) {
            this.tallyLevel(level, this.binsSeenByLevel);
            this.verifyNode(node);
            this.tallyEntries(node, this.binEntriesHistogram);
        }
    }

    private void tallyLevel(int levelArg, long[] nodesSeenByLevel) {
        int level = levelArg;
        if (level >= 65536 && (level &= 0xFFFF) > this.mainTreeMaxDepth) {
            this.mainTreeMaxDepth = level;
        }
        int n = level;
        nodesSeenByLevel[n] = nodesSeenByLevel[n] + 1L;
    }

    @Override
    public void incrementLNCount() {
        ++this.lnCount;
        if (this.progressInterval != 0 && this.progressStream != null && this.lnCount % (long)this.progressInterval == 0L) {
            this.progressStream.println(this.getStats());
        }
    }

    @Override
    public void incrementDeletedLNCount() {
        ++this.deletedLNCount;
    }

    private void tallyEntries(BIN bin, long[] binEntriesHistogram) {
        int nEntries = bin.getNEntries();
        int nonDeletedEntries = 0;
        for (int i = 0; i < nEntries; ++i) {
            if (bin.isEntryPendingDeleted(i) || bin.isEntryKnownDeleted(i)) continue;
            ++nonDeletedEntries;
        }
        int bucket = nonDeletedEntries * 100 / (bin.getMaxEntries() + 1);
        int n = bucket /= 10;
        binEntriesHistogram[n] = binEntriesHistogram[n] + 1L;
    }

    Set<Long> getINNodeIdsSeen() {
        return this.inNodeIdsSeen;
    }

    Set<Long> getBINNodeIdsSeen() {
        return this.binNodeIdsSeen;
    }

    long[] getINsByLevel() {
        return this.insSeenByLevel;
    }

    long[] getBINsByLevel() {
        return this.binsSeenByLevel;
    }

    long[] getBINEntriesHistogram() {
        return this.binEntriesHistogram;
    }

    long getLNCount() {
        return this.lnCount;
    }

    long getDeletedLNCount() {
        return this.deletedLNCount;
    }

    int getMainTreeMaxDepth() {
        return this.mainTreeMaxDepth;
    }

    public StatGroup getStats() {
        StatGroup group = new StatGroup("BTreeCount", "Btree node counts.");
        new LongStat(group, BTreeStatDefinition.BT_COUNT_INS, this.getINNodeIdsSeen().size());
        new LongStat(group, BTreeStatDefinition.BT_COUNT_BINS, this.getBINNodeIdsSeen().size());
        new LongStat(group, BTreeStatDefinition.BT_COUNT_LNS, this.getLNCount());
        new LongStat(group, BTreeStatDefinition.BT_COUNT_DELETED_LNS, this.getDeletedLNCount());
        new IntStat(group, BTreeStatDefinition.BT_COUNT_MAINTREE_MAXDEPTH, this.getMainTreeMaxDepth());
        new LongArrayStat(group, BTreeStatDefinition.BT_COUNT_INS_BYLEVEL, this.getINsByLevel());
        new LongArrayStat(group, BTreeStatDefinition.BT_COUNT_BINS_BYLEVEL, this.getBINsByLevel());
        new LongArrayStat(group, BTreeStatDefinition.BT_COUNT_BIN_ENTRIES_HISTOGRAM, this.getBINEntriesHistogram()){

            @Override
            protected String getFormattedValue() {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                if (this.array != null && this.array.length > 0) {
                    DecimalFormat fmt = FormatUtil.decimalScale0();
                    boolean first = true;
                    for (int i = 0; i < this.array.length; ++i) {
                        if (this.array[i] <= 0L) continue;
                        if (!first) {
                            sb.append("; ");
                        }
                        first = false;
                        int startPct = i * 10;
                        int endPct = (i + 1) * 10 - 1;
                        sb.append(startPct).append("-");
                        sb.append(endPct).append("%: ");
                        sb.append(fmt.format(this.array[i]));
                    }
                }
                sb.append("]");
                return sb.toString();
            }
        };
        return group;
    }
}

