/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.VLSN;

public class MasterTxn
extends Txn {
    private VLSN commitVLSN = VLSN.NULL_VLSN;
    private final NameIdPair nameIdPair;
    private int requiredAckCount = -1;
    private final long startMs = System.currentTimeMillis();
    private int preLogCommitEndDeltaMs = 0;
    private int repWriteStartDeltaMs = 0;
    private static final MasterTxnFactory DEFAULT_FACTORY;
    private static MasterTxnFactory factory;

    public MasterTxn(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) throws DatabaseException {
        super(envImpl, config, ReplicationContext.MASTER);
        this.nameIdPair = nameIdPair;
    }

    public CommitToken getCommitToken() {
        if (this.commitVLSN.isNull()) {
            return null;
        }
        RepImpl repImpl = (RepImpl)this.envImpl;
        return new CommitToken(repImpl.getUUID(), this.commitVLSN.getSequence());
    }

    public VLSN getCommitVLSN() {
        return this.commitVLSN;
    }

    protected long generateId(TxnManager txnManager, long ignore) {
        assert (ignore == 0L);
        return txnManager.getNextReplicatedTxnId();
    }

    protected void txnBeginHook(TransactionConfig config) throws DatabaseException {
        RepImpl repImpl = (RepImpl)this.envImpl;
        try {
            repImpl.txnBeginHook(this);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
    }

    protected void preLogCommitHook() throws DatabaseException {
        this.requiredAckCount = this.getCurrentRequiredAckCount();
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.preLogCommitHook(this);
        this.preLogCommitEndDeltaMs = (int)(System.currentTimeMillis() - this.startMs);
    }

    protected void postLogCommitHook(LogItem commitItem) throws DatabaseException {
        this.commitVLSN = commitItem.getHeader().getVLSN();
        try {
            RepImpl repImpl = (RepImpl)this.envImpl;
            repImpl.postLogCommitHook(this);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
    }

    protected void preLogAbortHook() throws DatabaseException {
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.preLogAbortHook(this);
    }

    protected void postLogAbortHook() {
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.postLogAbortHook(this);
    }

    public int getRequiredAckCount() {
        return this.requiredAckCount;
    }

    public int getCurrentRequiredAckCount() {
        RepNode repNode = ((RepImpl)this.envImpl).getRepNode();
        return repNode.minAckNodes(this.getCommitDurability()) - 1;
    }

    public void resetRequiredAckCount() {
        this.requiredAckCount = 0;
    }

    protected int getReplicatorNodeId() {
        return this.nameIdPair.getId();
    }

    public long getStartMs() {
        return this.startMs;
    }

    public void stampRepWriteTime() {
        this.repWriteStartDeltaMs = (int)(System.currentTimeMillis() - this.startMs);
    }

    public long messageTransferMs() {
        return this.repWriteStartDeltaMs > 0 ? (long)(this.repWriteStartDeltaMs - this.preLogCommitEndDeltaMs) : 0L;
    }

    protected boolean propagatePostCommitException(DatabaseException postCommitException) {
        return postCommitException instanceof InsufficientAcksException ? true : super.propagatePostCommitException(postCommitException);
    }

    public static MasterTxn create(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) {
        return factory.create(envImpl, config, nameIdPair);
    }

    public static void setFactory(MasterTxnFactory factory) {
        MasterTxn.factory = factory == null ? DEFAULT_FACTORY : factory;
    }

    public boolean isReplicationDefined() {
        return true;
    }

    static {
        factory = DEFAULT_FACTORY = new MasterTxnFactory(){

            public MasterTxn create(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) {
                return new MasterTxn(envImpl, config, nameIdPair);
            }
        };
    }

    public static interface MasterTxnFactory {
        public MasterTxn create(EnvironmentImpl var1, TransactionConfig var2, NameIdPair var3);
    }
}

