/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.utilint.PropUtil;

public class DurationConfigParam
extends ConfigParam {
    private static final String DEBUG_NAME = DurationConfigParam.class.getName();
    private String minString;
    private int minMillis;
    private String maxString;
    private int maxMillis;

    public DurationConfigParam(String configName, String minVal, String maxVal, String defaultValue, boolean mutable, boolean forReplication) {
        super(configName, defaultValue, mutable, forReplication);
        if (minVal != null) {
            this.minString = minVal;
            this.minMillis = PropUtil.parseDuration(minVal);
        }
        if (maxVal != null) {
            this.maxString = maxVal;
            this.maxMillis = PropUtil.parseDuration(maxVal);
        }
    }

    public void validateValue(String value) throws IllegalArgumentException {
        int millis;
        try {
            millis = PropUtil.parseDuration(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " fails validation: " + e.getMessage());
        }
        if (this.minString != null && millis < this.minMillis) {
            throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is less than min of " + this.minString);
        }
        if (this.maxString != null && millis > this.maxMillis) {
            throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is greater than max of " + this.maxString);
        }
    }
}

