/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SharedSelector
extends TargetSelector {
    private static final int MIN_ROTATIONS = 10;
    private static final int INIT_SIZE_THRESHOLD = 10;
    private final List<Subject> subjects = new ArrayList<Subject>();
    private int rotationIndex;
    private int specialEvictionIndex;
    private boolean needInitSizes = true;
    private int smallestSize;
    private int totalSize;
    private final AtomicInteger changedINs = new AtomicInteger();
    private final IntStat sharedCacheEnvs = new IntStat(this.stats, EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);

    public SharedSelector(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    StatGroup getINListStats(StatsConfig config) {
        StatGroup totalINListStats = new StatGroup("temp", "temp");
        if (config.getFast()) {
            return totalINListStats;
        }
        ArrayList<Subject> copy = null;
        SharedSelector sharedSelector = this;
        synchronized (sharedSelector) {
            copy = new ArrayList<Subject>(this.subjects);
        }
        for (Subject s : copy) {
            totalINListStats.addAll(s.env.getInMemoryINs().loadStats());
        }
        return totalINListStats;
    }

    @Override
    public StatGroup loadStats(StatsConfig config) {
        this.sharedCacheEnvs.set(this.subjects.size());
        return super.loadStats(config);
    }

    @Override
    public void noteINListChange(int nINs) {
        if (this.changedINs.addAndGet(nINs) > this.totalSize / 10) {
            this.needInitSizes = true;
        }
    }

    @Override
    public synchronized void addEnvironment(EnvironmentImpl env) {
        int nSubjects = this.subjects.size();
        for (int i = 0; i < nSubjects; ++i) {
            Subject subject = this.subjects.get(i);
            if (subject.env != env) continue;
            return;
        }
        Subject subject = new Subject();
        subject.env = env;
        subject.ins = env.getInMemoryINs();
        this.subjects.add(subject);
        this.needInitSizes = true;
    }

    @Override
    public synchronized void removeEnvironment(EnvironmentImpl env) {
        int nSubjects = this.subjects.size();
        for (int i = 0; i < nSubjects; ++i) {
            Subject subject = this.subjects.get(i);
            if (subject.env != env) continue;
            this.subjects.remove(i);
            this.needInitSizes = true;
            return;
        }
    }

    @Override
    public synchronized boolean checkEnv(EnvironmentImpl targetEnvImpl) {
        int nSubjects = this.subjects.size();
        for (int i = 0; i < nSubjects; ++i) {
            Subject subject = this.subjects.get(i);
            if (targetEnvImpl != subject.env) continue;
            return true;
        }
        return false;
    }

    @Override
    synchronized TargetSelector.SetupInfo startBatch(boolean doSpecialEviction) throws DatabaseException {
        int nSubjects;
        TargetSelector.SetupInfo setupInfo = new TargetSelector.SetupInfo();
        if (this.needInitSizes) {
            this.initSizes();
        }
        if (doSpecialEviction && (nSubjects = this.subjects.size()) > 0) {
            if (this.specialEvictionIndex >= nSubjects) {
                this.specialEvictionIndex = 0;
            }
            Subject subject = this.subjects.get(this.specialEvictionIndex);
            ++this.specialEvictionIndex;
            setupInfo.specialEvictionBytes = subject.env.specialEviction();
        }
        setupInfo.maxINsPerBatch = this.totalSize;
        return setupInfo;
    }

    @Override
    IN getNextIN() {
        int nSubjects = this.subjects.size();
        if (nSubjects == 0) {
            return null;
        }
        int nSubjectsExamined = 0;
        while (true) {
            if (this.rotationIndex >= nSubjects) {
                this.rotationIndex = 0;
            }
            Subject subject = this.subjects.get(this.rotationIndex);
            ++this.rotationIndex;
            if (subject.remaining > 0 && this.isEvictionAllowed(subject)) {
                subject.remaining -= this.smallestSize;
                if (subject.iter == null || !subject.iter.hasNext()) {
                    subject.iter = subject.ins.iterator();
                }
                if (subject.iter.hasNext()) {
                    return subject.iter.next();
                }
                subject.remaining = -1;
            }
            if (++nSubjectsExamined < nSubjects) continue;
            boolean foundAny = false;
            for (int i = 0; i < nSubjects; ++i) {
                Subject sub = this.subjects.get(i);
                if (sub.size <= 0) continue;
                sub.remaining = sub.size * 10;
                if (!this.isEvictionAllowed(sub)) continue;
                foundAny = true;
            }
            if (!foundAny) {
                return null;
            }
            nSubjectsExamined = 0;
        }
    }

    private boolean isEvictionAllowed(Subject subject) {
        return subject.env.getMemoryBudget().isTreeUsageAboveMinimum();
    }

    private void initSizes() {
        this.totalSize = 0;
        this.smallestSize = Integer.MAX_VALUE;
        int nSubjects = this.subjects.size();
        for (int i = 0; i < nSubjects; ++i) {
            Subject subject = this.subjects.get(i);
            int size = subject.ins.getSize();
            if (this.smallestSize > size) {
                this.smallestSize = size;
            }
            this.totalSize += size;
            subject.size = size;
            subject.remaining = size * 10;
        }
        this.needInitSizes = false;
    }

    @Override
    Iterator<IN> getScanIterator() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    void setScanIterator(Iterator<IN> iter) {
        throw EnvironmentFailureException.unexpectedState();
    }

    private static class Subject {
        EnvironmentImpl env;
        INList ins;
        Iterator<IN> iter;
        int size;
        int remaining;

        private Subject() {
        }
    }
}

