/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

public class SearchFileReader
extends FileReader {
    private LogEntryType targetType;
    private LogEntry logEntry;

    public SearchFileReader(EnvironmentImpl env, int readBufferSize, boolean forward, long startLsn, long endOfFileLsn, LogEntryType targetType) throws DatabaseException {
        super(env, readBufferSize, forward, startLsn, null, endOfFileLsn, -1L);
        this.targetType = targetType;
        this.logEntry = targetType.getNewLogEntry();
    }

    protected boolean isTargetEntry() {
        return this.targetType.equalsType(this.currentEntryHeader.getType());
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.logEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        return true;
    }

    public Object getLastObject() {
        return this.logEntry.getMainItem();
    }
}

