/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.sync.impl;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.sync.ProcessorMetadata;
import com.sleepycat.je.sync.SyncDataSet;
import com.sleepycat.je.sync.SyncProcessor;
import com.sleepycat.je.sync.impl.SyncCleanerBarrier;
import com.sleepycat.je.trigger.Trigger;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncDB {
    private static final String SYNC_TRIGGER_NAME = "syncTrigger";
    private final EnvironmentImpl envImpl;
    private final Database db;
    private final DatabaseImpl dbImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncDB(EnvironmentImpl envImpl, boolean allowCreate) throws DatabaseNotFoundException {
        Transaction txn;
        block5: {
            assert (envImpl != null);
            this.envImpl = envImpl;
            boolean success = false;
            Environment env = envImpl.getInternalEnvHandle();
            assert (env != null);
            txn = DbInternal.beginInternalTransaction(env, null);
            try {
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setAllowCreate(allowCreate);
                dbConfig.setTransactional(true);
                SyncCleanerBarrier.SyncTrigger trigger = new SyncCleanerBarrier.SyncTrigger(SYNC_TRIGGER_NAME);
                ArrayList<Trigger> list = new ArrayList<Trigger>();
                list.add(trigger);
                dbConfig.setTriggers(list);
                DbInternal.setReplicated(dbConfig, true);
                this.db = DbInternal.openInternalDatabase(env, txn, DbType.SYNC.getInternalName(), dbConfig);
                this.dbImpl = DbInternal.getDatabaseImpl(this.db);
                success = true;
                Object var10_9 = null;
                if (!success) break block5;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (success) {
                    txn.commit();
                    throw throwable;
                }
                txn.abort();
                throw throwable;
            }
            txn.commit();
            return;
        }
        txn.abort();
    }

    public void writeProcessorMetadata(Environment env, Transaction txn, String processorName, ProcessorMetadata metadata) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(metadata);
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        DatabaseEntry data = new DatabaseEntry(baos.toByteArray());
        this.writeData(env, txn, processorName, null, data, DataType.PROCESSOR_METADATA, null);
    }

    public ProcessorMetadata readProcessorMetadata(Environment env, Transaction txn, SyncProcessor processor) {
        DatabaseEntry data = new DatabaseEntry();
        this.readData(env, txn, processor.getName(), null, data, DataType.PROCESSOR_METADATA);
        if (data.getData() == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize());
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            assert (ois.available() == 0);
            ProcessorMetadata metadata = (ProcessorMetadata)object;
            for (SyncDataSet dataSet : metadata.getDataSets()) {
                dataSet.initSyncProcessor(processor);
            }
            return metadata;
        }
        catch (ClassNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public void writeChangeSetData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data, OpType opType) {
        this.writeData(env, txn, processorName, dataSetName, data, DataType.CHANGE_SET, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data, DataType dataType, OpType opType) {
        boolean operationOK;
        Locker locker;
        block8: {
            assert (env != null);
            locker = null;
            Cursor cursor = null;
            operationOK = false;
            try {
                locker = LockerFactory.getWritableLocker(env, txn, true, this.dbImpl.isTransactional(), this.dbImpl.isReplicated());
                cursor = this.makeCursor(locker);
                DatabaseEntry key = new DatabaseEntry();
                StringBinding.stringToEntry(SyncDB.generateKey(processorName, dataSetName, dataType), key);
                DatabaseEntry oldData = new DatabaseEntry();
                cursor.getSearchKey(key, oldData, null);
                if (dataType == DataType.CHANGE_SET) {
                    this.checkUsageErrors(oldData, opType, dataSetName);
                }
                OperationStatus status = null;
                status = opType == OpType.DELETE ? cursor.delete() : cursor.put(key, data);
                assert (status == OperationStatus.SUCCESS);
                operationOK = true;
                Object var15_14 = null;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
                if (locker != null) {
                    locker.operationEnd(operationOK);
                }
                throw throwable;
            }
            cursor.close();
            cursor = null;
        }
        if (locker != null) {
            locker.operationEnd(operationOK);
        }
    }

    private void checkUsageErrors(DatabaseEntry data, OpType opType, String dataSetName) {
        switch (opType) {
            case DELETE: {
                if (data.getData() != null) break;
                throw new IllegalStateException("Data set does not exist: " + dataSetName);
            }
            case INSERT: {
                if (data.getData() == null) break;
                throw new IllegalStateException("Data set already exists: " + dataSetName);
            }
            case UPDATE: {
                if (data.getData() != null) break;
                throw new IllegalStateException("Data set does not exist:" + dataSetName);
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unrecognized SyncDB operation type: " + (Object)((Object)opType));
            }
        }
    }

    public static String generateKey(String processorName, String dataSetName, DataType dataType) {
        String key = null;
        switch (dataType) {
            case PROCESSOR_METADATA: {
                key = processorName + "-";
                break;
            }
            case CHANGE_SET: {
                key = processorName + "-" + dataSetName + "-";
                break;
            }
            case PROCESSOR_TXN_DATA: {
                key = processorName + "-" + dataSetName + "-";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized data type.");
            }
        }
        return key + dataType.ordinal();
    }

    private Cursor makeCursor(Locker locker) {
        Cursor cursor = DbInternal.makeCursor(this.dbImpl, locker, CursorConfig.DEFAULT);
        return cursor;
    }

    public void readChangeSetData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data) {
        this.readData(env, txn, processorName, dataSetName, data, DataType.CHANGE_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data, DataType dataType) {
        boolean operationOK;
        Locker locker;
        block7: {
            assert (env != null);
            locker = null;
            Cursor cursor = null;
            operationOK = false;
            try {
                locker = LockerFactory.getReadableLocker(env, txn, this.dbImpl.isTransactional(), false);
                cursor = this.makeCursor(locker);
                DatabaseEntry key = new DatabaseEntry();
                StringBinding.stringToEntry(SyncDB.generateKey(processorName, dataSetName, dataType), key);
                OperationStatus status = cursor.getSearchKey(key, data, null);
                assert (data.getData() == null || status == OperationStatus.SUCCESS);
                operationOK = true;
                Object var13_12 = null;
                if (cursor == null) break block7;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
                if (locker != null) {
                    locker.operationEnd(operationOK);
                }
                throw throwable;
            }
            cursor.close();
            cursor = null;
        }
        if (locker != null) {
            locker.operationEnd(operationOK);
        }
    }

    public void writeProcessorTxnData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data) {
        this.writeData(env, txn, processorName, dataSetName, data, DataType.PROCESSOR_TXN_DATA, null);
    }

    public void readProcessorTxnData(Environment env, Transaction txn, String processorName, String dataSetName, DatabaseEntry data) {
        this.readData(env, txn, processorName, dataSetName, data, DataType.PROCESSOR_TXN_DATA);
    }

    public long getCount() {
        return this.dbImpl.count();
    }

    public DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, DatabaseEntry> readDataForType(DataType dataType, Environment env) {
        if (this.dbImpl == null) {
            return null;
        }
        Locker locker = null;
        boolean operationOK = false;
        HashMap<String, DatabaseEntry> readData = new HashMap<String, DatabaseEntry>();
        try {
            locker = LockerFactory.getReadableLocker(env, null, this.dbImpl.isTransactional(), false);
            Cursor cursor = this.makeCursor(locker);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (OperationStatus.SUCCESS == cursor.getNext(key, data, null)) {
                String keyName = StringBinding.entryToString(key);
                if (DataType.getDataType(keyName).equals((Object)dataType)) {
                    readData.put(keyName, data);
                }
                data = new DatabaseEntry();
            }
            operationOK = true;
            Object var11_10 = null;
            if (locker == null) return readData;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (locker == null) throw throwable;
            locker.operationEnd(operationOK);
            throw throwable;
        }
        locker.operationEnd(operationOK);
        return readData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        PROCESSOR_METADATA,
        CHANGE_SET,
        PROCESSOR_TXN_DATA;


        static DataType getDataType(String key) {
            int ordinal = new Integer(key.substring(key.length() - 1, key.length()));
            if (ordinal == PROCESSOR_METADATA.ordinal()) {
                return PROCESSOR_METADATA;
            }
            if (ordinal == CHANGE_SET.ordinal()) {
                return CHANGE_SET;
            }
            return PROCESSOR_TXN_DATA;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        DELETE,
        INSERT,
        UPDATE;

    }
}

