/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.utilint.SizeofMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class INKeyRep
extends INArrayRep<INKeyRep, Type, byte[]> {
    public abstract int length();

    public abstract boolean accountsForKeyByteMemUsage();

    public static class MaxKeySize
    extends INKeyRep {
        private static final int LENGTH_BYTES = 1;
        private static final byte NULL_KEY = 127;
        public static final byte DEFAULT_MAX_KEY_LENGTH = 16;
        public static final int MAX_KEYS = 256;
        private final byte[] keys;
        private final short keyLength;

        public MaxKeySize(int nodeMaxEntries, short maxKeySize) {
            assert (maxKeySize < 255);
            this.keyLength = (short)(maxKeySize + 1);
            this.keys = new byte[this.keyLength * nodeMaxEntries];
            for (int i = 0; i < nodeMaxEntries; ++i) {
                INKeyRep rep = this.set(i, null, null);
                assert (rep == this);
            }
        }

        public MaxKeySize(SizeofMarker marker) {
            this.keys = null;
            this.keyLength = 0;
        }

        public Type getType() {
            return Type.MAX_KEY_SIZE;
        }

        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from * this.keyLength, this.keys, to * this.keyLength, n * this.keyLength);
            return this;
        }

        public byte[] get(int idx) {
            int k = idx * this.keyLength;
            if (this.keys[k] == 127) {
                return null;
            }
            int length = this.keys[k] - -128;
            byte[] key = new byte[length];
            for (int i = 1; i <= length; ++i) {
                key[i - 1] = this.keys[k + i];
            }
            return key;
        }

        public INKeyRep set(int idx, byte[] key, IN parent) {
            int ki = idx * this.keyLength;
            if (key == null) {
                this.keys[ki] = 127;
                return this;
            }
            if (key.length >= this.keyLength) {
                Default newRep = this.expandToDefaultRep(parent);
                return newRep.set(idx, key, parent);
            }
            this.keys[ki] = (byte)(key.length + -128);
            for (int i = 1; i <= key.length; ++i) {
                this.keys[ki + i] = key[i - 1];
            }
            return this;
        }

        private Default expandToDefaultRep(IN parent) {
            int capacity = this.length();
            Default newRep = new Default(capacity);
            for (int i = 0; i < capacity; ++i) {
                byte[] k = this.get(i);
                INKeyRep rep = newRep.set(i, k, parent);
                assert (rep == newRep);
            }
            return newRep;
        }

        public long calculateMemorySize() {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(this.keys.length);
        }

        private static long getMemorySize(int maxKeys, int maxKeySize) {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(maxKeys * (maxKeySize + 1));
        }

        public int length() {
            return this.keys.length / this.keyLength;
        }

        public boolean accountsForKeyByteMemUsage() {
            return true;
        }

        public INKeyRep compact(IN parent) {
            return this;
        }

        void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINCompactKey().incrementAndGet();
            } else {
                evictor.getNINCompactKey().decrementAndGet();
            }
        }
    }

    public static class Default
    extends INKeyRep {
        private final byte[][] keys;

        Default(int nodeMaxEntries) {
            this.keys = new byte[nodeMaxEntries][];
        }

        public Default(SizeofMarker marker) {
            this.keys = null;
        }

        public Type getType() {
            return Type.DEFAULT;
        }

        public byte[] get(int idx) {
            return this.keys[idx];
        }

        public INKeyRep set(int idx, byte[] key, IN parent) {
            this.keys[idx] = key;
            return this;
        }

        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from, this.keys, to, n);
            return this;
        }

        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_KEYVALS_OVERHEAD + MemoryBudget.objectArraySize(this.keys.length);
        }

        public INKeyRep compact(IN parent) {
            if (this.keys.length > 256) {
                return this;
            }
            int compactMaxKeyLength = parent.getCompactMaxKeyLength();
            if (compactMaxKeyLength <= 0) {
                return this;
            }
            int keyCount = 0;
            int maxKeyLength = 0;
            int defaultKeyBytes = 0;
            for (byte[] key : this.keys) {
                if (key == null) continue;
                ++keyCount;
                if (key.length > maxKeyLength && (maxKeyLength = key.length) > compactMaxKeyLength) {
                    return this;
                }
                defaultKeyBytes += MemoryBudget.byteArraySize(key.length);
            }
            if (keyCount == 0) {
                return this;
            }
            long defaultSizeWithKeys = this.calculateMemorySize() + (long)defaultKeyBytes;
            if (defaultSizeWithKeys > MaxKeySize.getMemorySize(this.keys.length, maxKeyLength)) {
                return this.compactToMaxKeySizeRep(maxKeyLength, parent);
            }
            return this;
        }

        public int length() {
            return this.keys.length;
        }

        public boolean accountsForKeyByteMemUsage() {
            return false;
        }

        private MaxKeySize compactToMaxKeySizeRep(int maxKeyLength, IN parent) {
            MaxKeySize newRep = new MaxKeySize(this.keys.length, (short)maxKeyLength);
            for (int i = 0; i < this.keys.length; ++i) {
                INKeyRep rep = newRep.set(i, this.keys[i], parent);
                assert (rep == newRep);
            }
            return newRep;
        }

        void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DEFAULT,
        MAX_KEY_SIZE;

    }
}

