/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import com.sleepycat.utilint.Latency;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;

public class LatencyStat
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final int maxTrackedLatencyMillis;
    private volatile Values trackedValues;
    private int saveMin;
    private int saveMax;
    private float saveAvg;
    private int saveNumOps;
    private int saveNumRequests;
    private int save95;
    private int save99;
    private int saveRequestsOverflow;

    public LatencyStat(long maxTrackedLatencyMillis) {
        this.maxTrackedLatencyMillis = (int)maxTrackedLatencyMillis;
        this.clear();
    }

    public void clear() {
        this.clearInternal();
    }

    private synchronized Values clearInternal() {
        Values values = this.trackedValues;
        this.trackedValues = new Values(this.maxTrackedLatencyMillis);
        return values;
    }

    public Latency calculate() {
        return this.calculate(false);
    }

    public Latency calculateAndClear() {
        return this.calculate(true);
    }

    private synchronized Latency calculate(boolean clear) {
        int percent99Count;
        int percent95Count;
        Values values = clear ? this.clearInternal() : this.trackedValues;
        int totalOps = values.numOps.get();
        int totalRequests = values.numRequests.get();
        if (totalOps == 0 || totalRequests == 0) {
            return new Latency(this.maxTrackedLatencyMillis);
        }
        long totalNanos = values.totalNanos.get();
        int nOverflow = values.requestsOverflow.get();
        int maxIncludingOverflow = values.maxIncludingOverflow;
        int minIncludingOverflow = values.minIncludingOverflow;
        float avgMs = (float)((double)totalNanos * 1.0E-6 / (double)totalRequests);
        int percent95 = -1;
        int percent99 = -1;
        int avgMsInt = Math.round(avgMs);
        int max = Math.max(avgMsInt, maxIncludingOverflow);
        int min = Math.min(avgMsInt, minIncludingOverflow);
        int nTrackedRequests = totalRequests - nOverflow;
        if (nTrackedRequests == 1) {
            percent95Count = 1;
            percent99Count = 1;
        } else {
            percent95Count = (int)((double)nTrackedRequests * 0.95);
            percent99Count = (int)((double)nTrackedRequests * 0.99);
        }
        int histogramLength = values.histogram.length();
        int numRequestsSeen = 0;
        for (int latency = 0; latency < histogramLength; ++latency) {
            int count = values.histogram.get(latency);
            if (count == 0) continue;
            if (min > latency) {
                min = latency;
            }
            if (max < latency) {
                max = latency;
            }
            if (numRequestsSeen < percent95Count) {
                percent95 = latency;
            }
            if (numRequestsSeen < percent99Count) {
                percent99 = latency;
            }
            numRequestsSeen += count;
        }
        this.saveMax = max;
        this.saveMin = min;
        this.saveAvg = avgMs;
        this.saveNumOps = totalOps;
        this.saveNumRequests = totalRequests;
        this.save95 = percent95;
        this.save99 = percent99;
        this.saveRequestsOverflow = nOverflow;
        return new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumOps, this.saveNumRequests, this.save95, this.save99, this.saveRequestsOverflow);
    }

    public void set(long nanoLatency) {
        this.set(1, nanoLatency);
    }

    public void set(int numRecordedOps, long nanoLatency) {
        Values values = this.trackedValues;
        int millisRounded = (int)((nanoLatency + 500000L) / 1000000L);
        if (millisRounded >= this.maxTrackedLatencyMillis) {
            values.requestsOverflow.incrementAndGet();
        } else {
            values.histogram.incrementAndGet(millisRounded);
        }
        while (values.maxIncludingOverflow < millisRounded) {
            values.maxIncludingOverflow = millisRounded;
        }
        while (values.minIncludingOverflow > millisRounded) {
            values.minIncludingOverflow = millisRounded;
        }
        values.totalNanos.addAndGet(nanoLatency);
        values.numOps.addAndGet(numRecordedOps);
        values.numRequests.incrementAndGet();
    }

    public boolean isEmpty() {
        return this.trackedValues.numOps.get() == 0 || this.trackedValues.numRequests.get() == 0;
    }

    public String toString() {
        Latency results = new Latency(this.maxTrackedLatencyMillis, this.saveMin, this.saveMax, this.saveAvg, this.saveNumRequests, this.saveNumOps, this.save95, this.save99, this.saveRequestsOverflow);
        return results.toString();
    }

    private static class Values {
        final AtomicInteger numOps;
        final AtomicInteger numRequests;
        final AtomicLong totalNanos;
        final AtomicIntegerArray histogram;
        volatile int minIncludingOverflow;
        volatile int maxIncludingOverflow;
        final AtomicInteger requestsOverflow;

        Values(int maxTrackedLatencyMillis) {
            this.histogram = new AtomicIntegerArray(maxTrackedLatencyMillis);
            this.numOps = new AtomicInteger();
            this.numRequests = new AtomicInteger();
            this.requestsOverflow = new AtomicInteger();
            this.totalNanos = new AtomicLong();
            this.minIncludingOverflow = Integer.MAX_VALUE;
            this.maxIncludingOverflow = 0;
        }
    }
}

