/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.smartgwt.client.types;

/**
 * DynamicForms automatically choose the FormItem type for a field based on the&#010 <code>type</code> property of the
 * field.  The table below describes the default FormItem&#010 chosen for various values of the <code>type</code>
 * property.&#010 <P>&#010 You can also set ${isc.DocUtils.linkForRef('attr:FormItem.editorType','field.editorType')} to
 * the classname of a&#010 ${isc.DocUtils.linkForRef('class:FormItem')} to override this default mapping.
 */

public enum FormItemType implements ValueEnum {
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:TextItem')}, unless the lenght of the field (as specified by
     * ${isc.DocUtils.linkForRef('attr:DataSourceField.length')} attribute) is larger than the value&#010 specified by
     * ${isc.DocUtils.linkForRef('attr:DynamicForm.longTextEditorThreshold')}, a&#010
     * ${isc.DocUtils.linkForRef('class:TextAreaItem')} is shown.
     */
    TEXT("text"),
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:CheckboxItem')}
     */
    BOOLEAN("boolean"),
    /**
     * Same as <code>text</code> by default.                     Consider setting editorType:${isc.DocUtils.linkForRef('class:SpinnerItem')}.
     */
    INTEGER("integer"),
    /**
     * Same as <code>text</code> by default.                     Consider setting editorType:${isc.DocUtils.linkForRef('class:SpinnerItem')}.
     */
    FLOAT("float"),
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:DateItem')}
     */
    DATE("date"),
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:TimeItem')}
     */
    TIME("time"),
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:SelectItem')}.  Also true for any field that specifies a
     * ${isc.DocUtils.linkForRef('attr:FormItem.valueMap')}.  &#010                   Consider setting
     * editorType:${isc.DocUtils.linkForRef('class:ComboBoxItem')}.
     */
    ENUM("enum"),
    /**
     * Same as <code>text</code>
     */
    SEQUENCE("sequence"),
    /**
     * If ${isc.DocUtils.linkForRef('attr:DataSourceField.canEdit')}<code>:false</code> is set on the field, the value
     * is rendered as a ${isc.DocUtils.linkForRef('class:LinkItem')}.  Otherwise the field is rendered as a&#010
     * ${isc.DocUtils.linkForRef('class:TextItem')}.
     */
    LINK("link"),
    IMAGE("image"),
    CHECKBOX("checkbox"),
    STATIC_TEXT("staticText"),
    BLOB("blob"),
    MULTI_FILE("multifile"),
    MULTI_UPLOAD("multiupload"),
    UPLOAD("upload"),
    FILE("file"),
    BASE64_BINARY("base64Binary"),
    CYCLE_ITEM("CycleItem"),
    SELECT_OTHER("selectOther"),
    RELATION("relation"),

    SELECT_ITEM("SelectItem"),
    HIDDEN_ITEM("HiddenItem"),
    HEADER_ITEM("HeaderItem"),
    DATE_ITEM("DateItem"),
    BLURB_ITEM("BlurbItem"),
    COMBOBOX_ITEM("ComboBoxItem"),
    SPACER_ITEM("SpacerItem"),
    ROWSPACER_ITEM("RowSpacerItem"),
    CHECKBOX_ITEM("CheckboxItem"),
    STATICTEXT_ITEM("StaticTextItem"),
    LINK_ITEM("LinkItem"),
    CANVAS_ITEM("CanvasItem"),
    PICKTREE_ITEM("PickTreeItem"),
    BUTTON_ITEM("ButtonItem"),
    SUBMIT_ITEM("SubmitItem"),
    RESET_ITEM("ResetItem"),
    RICHTEXT_ITEM("RichTextItem"),
    FILE_ITEM("FileItem"),
    SLIDER_ITEM("SliderItem"),
    TOOLBAR_ITEM("ToolbarItem"),
    SECTION_ITEM("SectionItem"),
    TEXTAREA_ITEM("TextAreaItem"),
    TEXT_ITEM("TextItem"),
    UPLOAD_ITEM("UploadItem"),
    PASSWORD_ITEM("PasswordItem"),
    SPINNER_ITEM("SpinnerItem"),
    TIME_ITEM("TimeItem"),
    NATIVE_CHECKBOX_ITEM("NativeCheckboxItem"),
    RADIOGROUP_ITEM("radioGroup"),

    IMAGEFILE("imagefile"),
    /**
     * Rendered as a ${isc.DocUtils.linkForRef('class:UploadItem')}
     */
    BINARY("binary");
    private String value;

    FormItemType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

