/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
 
package com.smartgwt.client.widgets.form.fields;



import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.EnumUtil;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
   /**
    * A FormItem that displays an uneditable value.

    */
public class StaticTextItem extends FormItem {

    public static StaticTextItem getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        RefDataClass obj = RefDataClass.getRef(jsObj);
        if(obj != null) {
            obj.setJsObj(jsObj);
            return (StaticTextItem) obj;
        } else {
            return new StaticTextItem(jsObj);
        }
    }


    public StaticTextItem(){
        setType("StaticTextItem");
    }

    public StaticTextItem(JavaScriptObject jsObj){
        super(jsObj);
    }

    public StaticTextItem(String name) {
        setName(name);
        setType("StaticTextItem");
    }

    // ********************* Properties / Attributes ***********************

    /**
    * If true, item contents can wrap. If false, all the contents should appear on a single line.
    *
    * @param wrap wrap Default value is true
    */
    public void setWrap(Boolean wrap) {
        setAttribute("wrap", wrap);
    }
    /**
     * If true, item contents can wrap. If false, all the contents should appear on a single line.
     *
     *
     * @return Boolean
     *
     */
    public Boolean getWrap()  {
        return getAttributeAsBoolean("wrap");
    }

    /**
    * If true, text that exceeds the specified size of the form item will be clipped
    *
    * @param clipValue clipValue Default value is false
    */
    public void setClipValue(Boolean clipValue) {
        setAttribute("clipValue", clipValue);
    }
    /**
     * If true, text that exceeds the specified size of the form item will be clipped
     *
     *
     * @return Boolean
     *
     */
    public Boolean getClipValue()  {
        return getAttributeAsBoolean("clipValue");
    }

    /**
    * Base CSS class for this item
    *
    * @param textBoxStyle textBoxStyle Default value is "staticTextItem"
    */
    public void setTextBoxStyle(String textBoxStyle) {
        setAttribute("textBoxStyle", textBoxStyle);
    }
    /**
     * Base CSS class for this item
     *
     *
     * @return String
     *
     */
    public String getTextBoxStyle()  {
        return getAttributeAsString("textBoxStyle");
    }

    /**
    * By default HTML values in a staticTextItem will be interpreted by the browser. Setting this flag to true will causes HTML characters to be escaped, meaning the raw value of the field (for example <code>"&lt;b&gt;AAA&lt;/b&gt;"</code>) is displayed to the user rather than the interpreted HTML (for example <code>"<b>AAA</b>"</code>)
    *
    * @param outputAsHTML outputAsHTML Default value is false
    */
    public void setOutputAsHTML(Boolean outputAsHTML) {
        setAttribute("outputAsHTML", outputAsHTML);
    }
    /**
     * By default HTML values in a staticTextItem will be interpreted by the browser. Setting this flag to true will causes HTML characters to be escaped, meaning the raw value of the field (for example <code>"&lt;b&gt;AAA&lt;/b&gt;"</code>) is displayed to the user rather than the interpreted HTML (for example <code>"<b>AAA</b>"</code>)
     *
     *
     * @return Boolean
     *
     */
    public Boolean getOutputAsHTML()  {
        return getAttributeAsBoolean("outputAsHTML");
    }

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

}



