/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
 
package com.smartgwt.client.widgets.toolbar;



import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.EnumUtil;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
   /**
    * Simple subclass of Img with appearance appropriate for a ToolStrip separator

    */
public class ToolStripSeparator extends Img {

    public static ToolStripSeparator getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseWidget obj = BaseWidget.getRef(jsObj);
        if(obj != null) {
            return (ToolStripSeparator) obj;
        } else {
            return new ToolStripSeparator(jsObj);
        }
    }


    public ToolStripSeparator(){
        
    }

    public ToolStripSeparator(JavaScriptObject jsObj){
        super(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var widget = $wnd.isc.ToolStripSeparator.create(config);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;
    // ********************* Properties / Attributes ***********************

    /**
    * Path to separator image.
    *
    * @param skinImgDir skinImgDir Default value is "images/ToolStrip/"
    * @throws IllegalStateException this property cannot be changed after the component has been created
    */
    public void setSkinImgDir(String skinImgDir)  throws IllegalStateException {
        setAttribute("skinImgDir", skinImgDir, false);
    }
    /**
     * Path to separator image.
     *
     *
     * @return String
     *
     */
    public String getSkinImgDir()  {
        return getAttributeAsString("skinImgDir");
    }

    /**
    * Image for vertically oriented separator (for horizontal toolstrips).
    *
    * @param vSrc vSrc Default value is "[SKIN]separator.png"
    */
    public void setVSrc(String vSrc) {
        setAttribute("vSrc", vSrc, true);
    }
    /**
     * Image for vertically oriented separator (for horizontal toolstrips).
     *
     *
     * @return String
     *
     */
    public String getVSrc()  {
        return getAttributeAsString("vSrc");
    }

    /**
    * Image for horizontally oriented separator (for vertical toolstrips).
    *
    * @param hSrc hSrc Default value is "[SKIN]hseparator.png"
    */
    public void setHSrc(String hSrc) {
        setAttribute("hSrc", hSrc, true);
    }
    /**
     * Image for horizontally oriented separator (for vertical toolstrips).
     *
     *
     * @return String
     *
     */
    public String getHSrc()  {
        return getAttributeAsString("hSrc");
    }

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

}



