/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark;

import com.snowflake.snowpark.DataFrame$;
import com.snowflake.snowpark.FileOperationCommand$;
import com.snowflake.snowpark.GetResult;
import com.snowflake.snowpark.PutResult;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.Utils$;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import java.io.InputStream;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001U4AAC\u0006\u0003%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004B\u0001E\u0005I\u0011\u0001\"\t\u000b5\u0003A\u0011\u0001(\t\u000f]\u0003\u0011\u0013!C\u0001\u0005\")\u0001\f\u0001C\u00013\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0005g\nia)\u001b7f\u001fB,'/\u0019;j_:T!\u0001D\u0007\u0002\u0011Mtwn\u001e9be.T!AD\b\u0002\u0013Mtwn\u001e4mC.,'\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001e\fqa]3tg&|g\u000e\u0005\u0002\u001c95\t1\"\u0003\u0002\u001e\u0017\t91+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002!CA\u00111\u0004\u0001\u0005\u00063\t\u0001\rAG\u0001\u0004aV$H\u0003\u0002\u0013.uq\u00022!\n\u0015+\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#!B!se\u0006L\bCA\u000e,\u0013\ta3BA\u0005QkR\u0014Vm];mi\")af\u0001a\u0001_\u0005iAn\\2bY\u001aKG.\u001a(b[\u0016\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a'\u001b\u0005\u0019$B\u0001\u001b\u0012\u0003\u0019a$o\\8u}%\u0011aGJ\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027M!)1h\u0001a\u0001_\u0005i1\u000f^1hK2{7-\u0019;j_:Dq!P\u0002\u0011\u0002\u0003\u0007a(A\u0004paRLwN\\:\u0011\tAztfL\u0005\u0003\u0001f\u00121!T1q\u00035\u0001X\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\t1I\u000b\u0002?\t.\nQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u0015\u001a\n!\"\u00198o_R\fG/[8o\u0013\tauIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1aZ3u)\u0011y5\u000b\u0016,\u0011\u0007\u0015B\u0003\u000b\u0005\u0002\u001c#&\u0011!k\u0003\u0002\n\u000f\u0016$(+Z:vYRDQaO\u0003A\u0002=BQ!V\u0003A\u0002=\nq\u0002^1sO\u0016$H)\u001b:fGR|'/\u001f\u0005\b{\u0015\u0001\n\u00111\u0001?\u000359W\r\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005aQ\u000f\u001d7pC\u0012\u001cFO]3b[R!!,\u00180i!\t)3,\u0003\u0002]M\t!QK\\5u\u0011\u0015Yt\u00011\u00010\u0011\u0015yv\u00011\u0001a\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017AA5p\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006S\u001e\u0001\rA[\u0001\tG>l\u0007O]3tgB\u0011Qe[\u0005\u0003Y\u001a\u0012qAQ8pY\u0016\fg.\u0001\be_^tGn\\1e'R\u0014X-Y7\u0015\u0007\u0001|\u0007\u000fC\u0003<\u0011\u0001\u0007q\u0006C\u0003r\u0011\u0001\u0007!.\u0001\u0006eK\u000e|W\u000e\u001d:fgN\fqb\u001d;bO\u00164\u0015\u000e\\3Fq&\u001cHo\u001d\u000b\u0003URDQaO\u0005A\u0002=\u0002")
public final class FileOperation
extends Logging {
    private final Session session;

    public PutResult[] put(String localFileName, String stageLocation, Map<String, String> options) {
        SnowflakePlan plan = this.session.plans().fileOperationPlan(FileOperationCommand$.MODULE$.PutCommand(), Utils$.MODULE$.normalizeLocalFile(localFileName), Utils$.MODULE$.normalizeStageLocation(stageLocation), options);
        return (PutResult[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DataFrame$.MODULE$.apply(this.session, plan).collect())).map((Function1 & Serializable & scala.Serializable)row -> new PutResult(row.getString(0), row.getString(1), row.getDecimal(2).longValue(), row.getDecimal(3).longValue(), row.getString(4), row.getString(5), row.getString(6), row.getString(7), row.getString(8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PutResult.class)));
    }

    public Map<String, String> put$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public GetResult[] get(String stageLocation, String targetDirectory, Map<String, String> options) {
        SnowflakePlan plan = this.session.plans().fileOperationPlan(FileOperationCommand$.MODULE$.GetCommand(), Utils$.MODULE$.normalizeLocalFile(targetDirectory), Utils$.MODULE$.normalizeStageLocation(stageLocation), options);
        return (GetResult[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DataFrame$.MODULE$.apply(this.session, plan).collect())).map((Function1 & Serializable & scala.Serializable)row -> new GetResult(row.getString(0), row.getDecimal(1).longValue(), row.getString(2), row.getString(3), row.getString(4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GetResult.class)));
    }

    public Map<String, String> get$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void uploadStream(String stageLocation, InputStream inputStream, boolean compress) {
        Tuple3<String, String, String> tuple3 = Utils$.MODULE$.parseStageFileLocation(stageLocation);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String stageName = (String)tuple3._1();
        String pathName = (String)tuple3._2();
        String fileName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)stageName, (Object)pathName, (Object)fileName);
        String stageName2 = (String)tuple32._1();
        String pathName2 = (String)tuple32._2();
        String fileName2 = (String)tuple32._3();
        this.session.conn().uploadStream(stageName2, pathName2, inputStream, fileName2, compress);
    }

    public InputStream downloadStream(String stageLocation, boolean decompress) {
        Tuple3<String, String, String> tuple3 = Utils$.MODULE$.parseStageFileLocation(stageLocation);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String stageName = (String)tuple3._1();
        String pathName = (String)tuple3._2();
        String fileName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)stageName, (Object)pathName, (Object)fileName);
        String stageName2 = (String)tuple32._1();
        String pathName2 = (String)tuple32._2();
        String fileName2 = (String)tuple32._3();
        if (!this.stageFileExists(stageLocation)) {
            throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation, "Stage file does not exist");
        }
        String pathNameWithPrefix = pathName2.isEmpty() ? pathName2 : new StringBuilder(1).append("/").append(pathName2).toString();
        ObjectRef resultStream = ObjectRef.create(null);
        Utils$.MODULE$.withRetry(this.session.maxFileDownloadRetryCount(), new StringBuilder(51).append("Download stream from stage: ").append(stageName2).append(", file: ").append(pathNameWithPrefix).append("/").append(fileName2).append(", decompress: ").append(decompress).toString(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            resultStream$1.elem = $this.session.conn().downloadStream(stageName2, new StringBuilder(1).append(pathNameWithPrefix).append("/").append(fileName2).toString(), decompress);
        });
        return (InputStream)resultStream.elem;
    }

    private boolean stageFileExists(String stageLocation) {
        String normalizedLocation = Utils$.MODULE$.normalizeStageLocation(stageLocation);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.session.sql(new StringBuilder(3).append("ls ").append(normalizedLocation).toString()).collect())).nonEmpty();
    }

    public FileOperation(Session session) {
        this.session = session;
    }
}

