/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.Utils$;
import java.io.FileInputStream;
import java.util.Properties;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public final class Session$
extends Logging {
    public static Session$ MODULE$;
    private final InheritableThreadLocal<Session> com$snowflake$snowpark$Session$$activeSession;
    private Option<Session> globalStoredProcSession;

    static {
        new Session$();
    }

    public Session apply(SnowflakeConnectionV1 connection) {
        return this.builder().createInternal((Option<SnowflakeConnectionV1>)new Some((Object)connection));
    }

    public Map<String, String> loadConfFromFile(String configFile) {
        Properties prop = new Properties();
        ObjectRef options = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        prop.load(new FileInputStream(configFile));
        prop.entrySet().forEach(entry -> {
            options$1.elem = ((Map)options$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.getKey().toString()), (Object)entry.getValue().toString()));
        });
        return (Map)options.elem;
    }

    public Session.SessionBuilder builder() {
        return new Session.SessionBuilder();
    }

    public InheritableThreadLocal<Session> com$snowflake$snowpark$Session$$activeSession() {
        return this.com$snowflake$snowpark$Session$$activeSession;
    }

    private Option<Session> globalStoredProcSession() {
        return this.globalStoredProcSession;
    }

    private void globalStoredProcSession_$eq(Option<Session> x$1) {
        this.globalStoredProcSession = x$1;
    }

    public Session com$snowflake$snowpark$Session$$setActiveSession(Session session) {
        this.logInfo(new StringBuilder(30).append("Snowpark Session information: ").append(session.sessionInfo()).toString());
        if (!session.conn().isStoredProc()) {
            if (this.com$snowflake$snowpark$Session$$activeSession().get() != null) {
                this.logInfo("Overwriting an already active session in this thread");
            }
            this.com$snowflake$snowpark$Session$$activeSession().set(session);
        } else {
            if (this.globalStoredProcSession().isDefined()) {
                throw ErrorMessage$.MODULE$.MISC_SP_ACTIVE_SESSION_RESET();
            }
            this.globalStoredProcSession_$eq((Option<Session>)new Some((Object)session));
        }
        return session;
    }

    public void resetGlobalStoredProcSession() {
        this.globalStoredProcSession_$eq((Option<Session>)None$.MODULE$);
        this.logInfo("reset global stored proc session");
    }

    public Option<Session> getActiveSession() {
        if (this.globalStoredProcSession().isDefined()) {
            this.logInfo("global stored proc session is defined, returned it instead of the active session");
            return this.globalStoredProcSession();
        }
        return Option$.MODULE$.apply(this.com$snowflake$snowpark$Session$$activeSession().get());
    }

    private void disableStderr() {
        this.logInfo("Closing stderr and redirecting to stdout");
        System.err.close();
        System.setErr(System.out);
        this.logInfo("Done closing stderr and redirecting to stdout");
    }

    private Session$() {
        MODULE$ = this;
        Utils$.MODULE$.checkScalaVersionCompatibility();
        if (!package$.MODULE$.env().get((Object)"DISABLE_REDIRECT_STDERR").isDefined()) {
            this.disableStderr();
        }
        this.com$snowflake$snowpark$Session$$activeSession = new InheritableThreadLocal();
        this.globalStoredProcSession = None$.MODULE$;
    }
}

