/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.snowflake.client.util.SecretDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Logging {
    private Logger curLog = null;
    protected final String logName = this.getClassName();

    private String getClassName() {
        String name = this.getClass().getName();
        if (name.endsWith("$")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected Logger log() {
        if (this.curLog == null) {
            this.curLog = LoggerFactory.getLogger((String)this.logName);
        }
        return this.curLog;
    }

    protected void logInfo(String msg) {
        if (this.log().isInfoEnabled()) {
            this.log().info(Logging.maskSecrets(msg));
        }
    }

    protected void logDebug(String msg) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(Logging.maskSecrets(msg));
        }
    }

    protected void logTrace(String msg) {
        if (this.log().isTraceEnabled()) {
            this.log().trace(Logging.maskSecrets(msg));
        }
    }

    protected void logWarning(String msg) {
        if (this.log().isWarnEnabled()) {
            this.log().warn(Logging.maskSecrets(msg));
        }
    }

    protected void logError(String msg) {
        if (this.log().isErrorEnabled()) {
            this.log().error(Logging.maskSecrets(msg));
        }
    }

    protected void logInfo(String msg, Throwable throwable) {
        if (this.log().isInfoEnabled()) {
            this.log().info(Logging.maskSecrets(msg, throwable));
        }
    }

    protected void logDebug(String msg, Throwable throwable) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(Logging.maskSecrets(msg, throwable));
        }
    }

    protected void logTrace(String msg, Throwable throwable) {
        if (this.log().isTraceEnabled()) {
            this.log().trace(Logging.maskSecrets(msg, throwable));
        }
    }

    protected void logWarning(String msg, Throwable throwable) {
        if (this.log().isWarnEnabled()) {
            this.log().warn(Logging.maskSecrets(msg, throwable));
        }
    }

    protected void logError(String msg, Throwable throwable) {
        if (this.log().isErrorEnabled()) {
            this.log().error(Logging.maskSecrets(msg, throwable));
        }
    }

    public static String maskSecrets(String msg) {
        if (msg != null) {
            return SecretDetector.maskSecrets((String)msg);
        }
        return null;
    }

    public static String maskSecrets(String msg, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return Logging.maskSecrets(msg) + "\n" + Logging.maskSecrets(writer.toString());
    }
}

