/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.GroupingSets;
import com.snowflake.snowpark.Row;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.DataFrameAsyncActor;
import com.snowflake.snowpark_java.DataFrameNaFunctions;
import com.snowflake.snowpark_java.DataFrameStatFunctions;
import com.snowflake.snowpark_java.DataFrameWriter;
import com.snowflake.snowpark_java.HasCachedResult;
import com.snowflake.snowpark_java.RelationalGroupedDataFrame;
import com.snowflake.snowpark_java.TableFunction;
import com.snowflake.snowpark_java.types.InternalUtils;
import com.snowflake.snowpark_java.types.StructType;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import scala.Option;
import scala.collection.Iterator;

public class DataFrame
extends Logging
implements Cloneable {
    private final com.snowflake.snowpark.DataFrame df;

    DataFrame(com.snowflake.snowpark.DataFrame df) {
        this.df = df;
    }

    public StructType schema() {
        return InternalUtils.createStructType(this.df.schema());
    }

    public HasCachedResult cacheResult() {
        return new HasCachedResult(this.df.cacheResult());
    }

    public void explain() {
        this.df.explain();
    }

    public DataFrame toDF(String ... colNames) {
        return new DataFrame(this.df.toDF(JavaUtils.stringArrayToStringSeq(colNames)));
    }

    public DataFrame withColumn(String colName, Column col) {
        return new DataFrame(this.df.withColumn(colName, col.toScalaColumn()));
    }

    public DataFrame withColumns(String[] colNames, Column[] values) {
        return new DataFrame(this.df.withColumns(JavaUtils.stringArrayToStringSeq(colNames), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(values))));
    }

    public DataFrame rename(String newName, Column col) {
        return new DataFrame(this.df.rename(newName, col.toScalaColumn()));
    }

    public DataFrame select(Column ... columns) {
        return new DataFrame(this.df.select(Column.toScalaColumnArray(columns)));
    }

    public DataFrame select(String ... columnNames) {
        return new DataFrame(this.df.select(columnNames));
    }

    public DataFrame drop(Column ... columns) {
        return new DataFrame(this.df.drop(Column.toScalaColumnArray(columns)));
    }

    public DataFrame drop(String ... columnNames) {
        return new DataFrame(this.df.drop(columnNames));
    }

    public DataFrame filter(Column condition) {
        return new DataFrame(this.df.filter(condition.toScalaColumn()));
    }

    public DataFrame where(Column condition) {
        return this.filter(condition);
    }

    public DataFrame agg(Column ... exprs) {
        return new DataFrame(this.df.agg(Column.toScalaColumnArray(exprs)));
    }

    public DataFrame distinct() {
        return new DataFrame(this.df.distinct());
    }

    public DataFrame dropDuplicates(String ... colNames) {
        return new DataFrame(this.df.dropDuplicates(JavaUtils.stringArrayToStringSeq(colNames)));
    }

    public DataFrame union(DataFrame other) {
        return new DataFrame(this.df.union(other.df));
    }

    public DataFrame unionAll(DataFrame other) {
        return new DataFrame(this.df.unionAll(other.getScalaDataFrame()));
    }

    public DataFrame unionByName(DataFrame other) {
        return new DataFrame(this.df.unionByName(other.getScalaDataFrame()));
    }

    public DataFrame unionAllByName(DataFrame other) {
        return new DataFrame(this.df.unionAllByName(other.getScalaDataFrame()));
    }

    public DataFrame intersect(DataFrame other) {
        return new DataFrame(this.df.intersect(other.getScalaDataFrame()));
    }

    public DataFrame except(DataFrame other) {
        return new DataFrame(this.df.except(other.getScalaDataFrame()));
    }

    public DataFrame clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.logWarning(e.getMessage());
        }
        return new DataFrame(this.df.clone());
    }

    public DataFrame join(DataFrame right) {
        return new DataFrame(this.df.join(right.getScalaDataFrame()));
    }

    public DataFrame join(DataFrame right, String usingColumn) {
        return new DataFrame(this.df.join(right.getScalaDataFrame(), usingColumn));
    }

    public DataFrame join(DataFrame right, String[] usingColumns) {
        return new DataFrame(this.df.join(right.getScalaDataFrame(), JavaUtils.stringArrayToStringSeq(usingColumns)));
    }

    public DataFrame join(DataFrame right, String[] usingColumns, String joinType) {
        return new DataFrame(this.df.join(right.getScalaDataFrame(), JavaUtils.stringArrayToStringSeq(usingColumns), joinType));
    }

    public DataFrame join(DataFrame right, Column joinExpr) {
        return new DataFrame(this.df.join(right.getScalaDataFrame(), joinExpr.toScalaColumn()));
    }

    public DataFrame join(DataFrame right, Column joinExpr, String joinType) {
        return new DataFrame(this.df.join(right.getScalaDataFrame(), joinExpr.toScalaColumn(), joinType));
    }

    public DataFrame crossJoin(DataFrame right) {
        return new DataFrame(this.df.crossJoin(right.getScalaDataFrame()));
    }

    public DataFrame naturalJoin(DataFrame right) {
        return new DataFrame(this.df.naturalJoin(right.getScalaDataFrame()));
    }

    public DataFrame naturalJoin(DataFrame right, String joinType) {
        return new DataFrame(this.df.naturalJoin(right.getScalaDataFrame(), joinType));
    }

    public DataFrame sort(Column ... sortExprs) {
        return new DataFrame(this.df.sort(Column.toScalaColumnArray(sortExprs)));
    }

    public DataFrame limit(int n) {
        return new DataFrame(this.df.limit(n));
    }

    public RelationalGroupedDataFrame groupBy(Column ... cols) {
        return new RelationalGroupedDataFrame(this.df.groupBy(Column.toScalaColumnArray(cols)));
    }

    public RelationalGroupedDataFrame groupBy(String ... colNames) {
        return new RelationalGroupedDataFrame(this.df.groupBy(colNames));
    }

    public RelationalGroupedDataFrame rollup(Column ... cols) {
        return new RelationalGroupedDataFrame(this.df.rollup(Column.toScalaColumnArray(cols)));
    }

    public RelationalGroupedDataFrame rollup(String ... colNames) {
        return new RelationalGroupedDataFrame(this.df.rollup(colNames));
    }

    public RelationalGroupedDataFrame cube(Column ... cols) {
        return new RelationalGroupedDataFrame(this.df.cube(Column.toScalaColumnArray(cols)));
    }

    public RelationalGroupedDataFrame cube(String ... colNames) {
        return new RelationalGroupedDataFrame(this.df.cube(JavaUtils.stringArrayToStringSeq(colNames)));
    }

    public RelationalGroupedDataFrame groupByGroupingSets(com.snowflake.snowpark_java.GroupingSets ... sets) {
        GroupingSets[] arr = new GroupingSets[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            arr[i] = sets[i].getScalaGroupingSets();
        }
        return new RelationalGroupedDataFrame(this.df.groupByGroupingSets(JavaUtils.groupingSetArrayToSeq(arr)));
    }

    public RelationalGroupedDataFrame pivot(Column pivotColumn, Object[] values) {
        return new RelationalGroupedDataFrame(this.df.pivot(pivotColumn.toScalaColumn(), JavaUtils.objectArrayToSeq(values)));
    }

    public RelationalGroupedDataFrame pivot(String pivotColumn, Object[] values) {
        return new RelationalGroupedDataFrame(this.df.pivot(pivotColumn, JavaUtils.objectArrayToSeq(values)));
    }

    public long count() {
        return this.df.count();
    }

    public Column col(String colName) {
        return new Column(this.df.col(colName));
    }

    public DataFrame alias(String alias) {
        return new DataFrame(this.df.alias(alias));
    }

    public com.snowflake.snowpark_java.Row[] collect() {
        Row[] rows = this.df.collect();
        com.snowflake.snowpark_java.Row[] result = new com.snowflake.snowpark_java.Row[rows.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new com.snowflake.snowpark_java.Row(rows[i]);
        }
        return result;
    }

    public java.util.Iterator<com.snowflake.snowpark_java.Row> toLocalIterator() {
        return DataFrame.toJavaIterator(this.df.toLocalIterator());
    }

    public void show() {
        this.df.show();
    }

    public void show(int n) {
        this.df.show(n);
    }

    public void show(int n, int maxWidth) {
        this.df.show(n, maxWidth);
    }

    public void createOrReplaceView(String viewName) {
        this.df.createOrReplaceView(viewName);
    }

    public void createOrReplaceView(String[] multipartIdentifier) {
        this.df.createOrReplaceView(JavaUtils.stringArrayToStringSeq(multipartIdentifier));
    }

    public void createOrReplaceTempView(String viewName) {
        this.df.createOrReplaceTempView(viewName);
    }

    public void createOrReplaceTempView(String[] multipartIdentifier) {
        this.df.createOrReplaceTempView(JavaUtils.stringArrayToStringSeq(multipartIdentifier));
    }

    public Optional<com.snowflake.snowpark_java.Row> first() {
        Option<Row> result = this.df.first();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new com.snowflake.snowpark_java.Row((Row)result.get()));
    }

    public com.snowflake.snowpark_java.Row[] first(int n) {
        Row[] result = this.df.first(n);
        com.snowflake.snowpark_java.Row[] javaRows = new com.snowflake.snowpark_java.Row[n];
        for (int i = 0; i < result.length; ++i) {
            javaRows[i] = new com.snowflake.snowpark_java.Row(result[i]);
        }
        return javaRows;
    }

    public DataFrame sample(long num) {
        return new DataFrame(this.df.sample(num));
    }

    public DataFrame sample(double probabilityFraction) {
        return new DataFrame(this.df.sample(probabilityFraction));
    }

    public DataFrame[] randomSplit(double[] weights) {
        com.snowflake.snowpark.DataFrame[] result = this.df.randomSplit(weights);
        DataFrame[] javaDF = new DataFrame[result.length];
        for (int i = 0; i < javaDF.length; ++i) {
            javaDF[i] = new DataFrame(result[i]);
        }
        return javaDF;
    }

    public DataFrame flatten(Column input) {
        return new DataFrame(this.df.flatten(input.toScalaColumn()));
    }

    public DataFrame flatten(Column input, String path, boolean outer, boolean recursive, String mode) {
        return new DataFrame(this.df.flatten(input.toScalaColumn(), path, outer, recursive, mode));
    }

    public DataFrameWriter write() {
        return new DataFrameWriter(this.df.write(), this.getScalaDataFrame().session());
    }

    public DataFrameNaFunctions na() {
        return new DataFrameNaFunctions(this.df.na());
    }

    public DataFrameStatFunctions stat() {
        return new DataFrameStatFunctions(this.df.stat());
    }

    public DataFrameAsyncActor async() {
        return new DataFrameAsyncActor(this);
    }

    public DataFrame join(TableFunction func, Column ... args) {
        return new DataFrame(this.df.join(func.getScalaTableFunction(), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(args))));
    }

    public DataFrame join(TableFunction func, Column[] args, Column[] partitionBy, Column[] orderBy) {
        return new DataFrame(this.df.join(func.getScalaTableFunction(), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(args)), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(partitionBy)), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(orderBy))));
    }

    public DataFrame join(TableFunction func, Map<String, Column> args) {
        HashMap<String, com.snowflake.snowpark.Column> scalaArgs = new HashMap<String, com.snowflake.snowpark.Column>();
        for (Map.Entry<String, Column> entry : args.entrySet()) {
            scalaArgs.put(entry.getKey(), entry.getValue().toScalaColumn());
        }
        return new DataFrame(this.df.join(func.getScalaTableFunction(), JavaUtils.javaStringColumnMapToScala(scalaArgs)));
    }

    public DataFrame join(TableFunction func, Map<String, Column> args, Column[] partitionBy, Column[] orderBy) {
        HashMap<String, com.snowflake.snowpark.Column> scalaArgs = new HashMap<String, com.snowflake.snowpark.Column>();
        for (Map.Entry<String, Column> entry : args.entrySet()) {
            scalaArgs.put(entry.getKey(), entry.getValue().toScalaColumn());
        }
        return new DataFrame(this.df.join(func.getScalaTableFunction(), JavaUtils.javaStringColumnMapToScala(scalaArgs), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(partitionBy)), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(orderBy))));
    }

    public DataFrame join(Column func) {
        return new DataFrame(this.df.join(func.toScalaColumn()));
    }

    public DataFrame join(Column func, Column[] partitionBy, Column[] orderBy) {
        return new DataFrame(this.df.join(func.toScalaColumn(), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(partitionBy)), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(orderBy))));
    }

    com.snowflake.snowpark.DataFrame getScalaDataFrame() {
        return this.df;
    }

    static java.util.Iterator<com.snowflake.snowpark_java.Row> toJavaIterator(final Iterator<Row> input) {
        return new java.util.Iterator<com.snowflake.snowpark_java.Row>(){

            @Override
            public boolean hasNext() {
                return input.hasNext();
            }

            @Override
            public com.snowflake.snowpark_java.Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new com.snowflake.snowpark_java.Row((Row)input.next());
            }
        };
    }
}

