/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.analyzer.DateTimeUtils$;
import com.snowflake.snowpark.internal.analyzer.Literal;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.ByteType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType$;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.FloatType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.ShortType$;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.TimestampType$;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;

public final class Literal$
implements Serializable {
    public static Literal$ MODULE$;
    private MathContext bigDecimalRoundContext;
    private volatile boolean bitmap$0;

    static {
        new Literal$();
    }

    private MathContext bigDecimalRoundContext$lzycompute() {
        Literal$ literal$ = this;
        synchronized (literal$) {
            if (!this.bitmap$0) {
                this.bigDecimalRoundContext = new MathContext(DecimalType$.MODULE$.MAX_PRECISION());
                this.bitmap$0 = true;
            }
        }
        return this.bigDecimalRoundContext;
    }

    private MathContext bigDecimalRoundContext() {
        return !this.bitmap$0 ? this.bigDecimalRoundContext$lzycompute() : this.bigDecimalRoundContext;
    }

    private scala.math.BigDecimal roundBigDecimal(scala.math.BigDecimal decimal) {
        return decimal.round(this.bigDecimalRoundContext());
    }

    public Literal apply(Object v) {
        Literal literal;
        Object object = v;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            literal = this.apply(BoxesRunTime.boxToInteger((int)n), (Option<DataType>)Option$.MODULE$.apply((Object)IntegerType$.MODULE$));
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            literal = this.apply(BoxesRunTime.boxToLong((long)l), (Option<DataType>)Option$.MODULE$.apply((Object)LongType$.MODULE$));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            literal = this.apply(BoxesRunTime.boxToDouble((double)d), (Option<DataType>)Option$.MODULE$.apply((Object)DoubleType$.MODULE$));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            literal = this.apply(BoxesRunTime.boxToFloat((float)f), (Option<DataType>)Option$.MODULE$.apply((Object)FloatType$.MODULE$));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            literal = this.apply(BoxesRunTime.boxToByte((byte)by), (Option<DataType>)Option$.MODULE$.apply((Object)ByteType$.MODULE$));
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            literal = this.apply(BoxesRunTime.boxToShort((short)s), (Option<DataType>)Option$.MODULE$.apply((Object)ShortType$.MODULE$));
        } else if (object instanceof String) {
            String string = (String)object;
            literal = this.apply(string, (Option<DataType>)Option$.MODULE$.apply((Object)StringType$.MODULE$));
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            literal = this.apply(((Object)BoxesRunTime.boxToCharacter((char)c)).toString(), (Option<DataType>)Option$.MODULE$.apply((Object)StringType$.MODULE$));
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            literal = this.apply(BoxesRunTime.boxToBoolean((boolean)bl), (Option<DataType>)Option$.MODULE$.apply((Object)BooleanType$.MODULE$));
        } else if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            scala.math.BigDecimal scalaDecimal = this.roundBigDecimal(bigDecimal);
            literal = this.apply(scalaDecimal, (Option<DataType>)Option$.MODULE$.apply((Object)DecimalType$.MODULE$.apply(scalaDecimal)));
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            scala.math.BigDecimal scalaDecimal = BigDecimal$.MODULE$.decimal(bigDecimal, this.bigDecimalRoundContext());
            literal = this.apply(scalaDecimal, (Option<DataType>)Option$.MODULE$.apply((Object)DecimalType$.MODULE$.apply(scalaDecimal)));
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            literal = this.apply(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), (Option<DataType>)Option$.MODULE$.apply((Object)TimestampType$.MODULE$));
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            literal = this.apply(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.javaTimestampToMicros(timestamp)), (Option<DataType>)Option$.MODULE$.apply((Object)TimestampType$.MODULE$));
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            literal = this.apply(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(localDate)), (Option<DataType>)Option$.MODULE$.apply((Object)DateType$.MODULE$));
        } else if (object instanceof Date) {
            Date date = (Date)object;
            literal = this.apply(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.javaDateToDays(date)), (Option<DataType>)Option$.MODULE$.apply((Object)DateType$.MODULE$));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            literal = this.apply(byArray, (Option<DataType>)Option$.MODULE$.apply((Object)BinaryType$.MODULE$));
        } else if (object == null) {
            literal = this.apply(null, (Option<DataType>)None$.MODULE$);
        } else if (object instanceof Literal) {
            Literal literal2;
            literal = literal2 = (Literal)object;
        } else {
            throw ErrorMessage$.MODULE$.PLAN_CANNOT_CREATE_LITERAL(v.getClass().getCanonicalName(), String.valueOf(v));
        }
        return literal;
    }

    public Literal apply(Object value, Option<DataType> dataTypeOption) {
        return new Literal(value, dataTypeOption);
    }

    public Option<Tuple2<Object, Option<DataType>>> unapply(Literal x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.value(), x$0.dataTypeOption()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Literal$() {
        MODULE$ = this;
    }
}

