/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.Row;
import com.snowflake.snowpark_java.TypedAsyncJob;
import java.util.Iterator;

public class DataFrameAsyncActor {
    private final com.snowflake.snowpark.DataFrameAsyncActor dfAsync;
    protected final Session session;

    DataFrameAsyncActor(DataFrame df) {
        this.dfAsync = df.getScalaDataFrame().async();
        this.session = df.getScalaDataFrame().session();
    }

    public TypedAsyncJob<Row[]> collect() {
        return TypedAsyncJob.createRowArrayJob(this.dfAsync.collect(), this.session);
    }

    public TypedAsyncJob<Iterator<Row>> toLocalIterator() {
        return TypedAsyncJob.createRowIteratorJob(this.dfAsync.toLocalIterator(), this.session);
    }

    public TypedAsyncJob<Long> count() {
        return TypedAsyncJob.createLongJob(this.dfAsync.count(), this.session);
    }
}

