/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

class ApplicationExecutor {
    private final Path loggingDirectory;
    private final Path workingDirectory;
    private final Path applicationExecutable;
    private final List<String> jvmArguments;
    private final String prefix;
    private final String javaHome;

    ApplicationExecutor(String javaHome, Path loggingDirectory, Path workingDirectory, Path applicationExecutable, List<String> jvmArguments, String prefix) {
        this.javaHome = javaHome;
        this.loggingDirectory = loggingDirectory;
        this.workingDirectory = workingDirectory;
        this.applicationExecutable = applicationExecutable;
        this.jvmArguments = jvmArguments;
        this.prefix = prefix;
    }

    ApplicationExecutor(Path workingDirectory, Path loggingDirectory, Path applicationExecutable, List<String> jvmArguments, String prefix) {
        this(System.getProperty("java.home"), loggingDirectory, workingDirectory, applicationExecutable, jvmArguments, prefix);
    }

    Process start(List<String> startArguments) throws IOException {
        ArrayList<String> applicationArguments = new ArrayList<String>();
        applicationArguments.addAll(Collections.singletonList(this.applicationExecutable.toString()));
        applicationArguments.addAll(startArguments);
        Path argumentsLog = this.loggingDirectory.resolve(this.prefix + "-arguments.log");
        Files.deleteIfExists(argumentsLog);
        try {
            Files.write(argumentsLog, applicationArguments, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write argument log file", e);
        }
        Path stdErrOut = this.loggingDirectory.resolve(this.prefix + "-stderr.log");
        Path stdOutOut = this.loggingDirectory.resolve(this.prefix + "-stdout.log");
        Files.deleteIfExists(stdErrOut);
        Files.deleteIfExists(stdOutOut);
        ProcessBuilder pb = new ProcessBuilder(applicationArguments);
        pb.redirectError(stdErrOut.toFile());
        pb.redirectOutput(stdOutOut.toFile());
        pb.directory(this.workingDirectory.toFile());
        return pb.start();
    }

    int startAndWaitUntilEnded(List<String> args) throws IOException, InterruptedException {
        Process start = this.start(args);
        return start.waitFor();
    }

    Path getStdout() {
        return this.loggingDirectory.resolve(this.prefix + "-stdout.log");
    }

    Stream<String> createLogStream() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/mvn-stdout.log");
        return new BufferedReader(new InputStreamReader(resourceAsStream, Charset.defaultCharset())).lines();
    }

    Path getStdErr() {
        return this.loggingDirectory.resolve(this.prefix + "-stderr.log");
    }
}

