/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.AnnotationHelper;
import com.soebes.itf.jupiter.extension.ApplicationExecutor;
import com.soebes.itf.jupiter.extension.DirectoryHelper;
import com.soebes.itf.jupiter.extension.DirectoryResolverResult;
import com.soebes.itf.jupiter.extension.MavenLocator;
import com.soebes.itf.jupiter.extension.MavenPredefinedRepository;
import com.soebes.itf.jupiter.extension.MavenProjectLocation;
import com.soebes.itf.jupiter.extension.MavenProjectSources;
import com.soebes.itf.jupiter.extension.ModelReader;
import com.soebes.itf.jupiter.extension.ParameterType;
import com.soebes.itf.jupiter.extension.PathUtils;
import com.soebes.itf.jupiter.extension.PropertiesFilter;
import com.soebes.itf.jupiter.extension.StorageHelper;
import com.soebes.itf.jupiter.maven.MavenCacheResult;
import com.soebes.itf.jupiter.maven.MavenExecutionResult;
import com.soebes.itf.jupiter.maven.MavenLog;
import com.soebes.itf.jupiter.maven.MavenProjectResult;
import com.soebes.itf.jupiter.maven.ProjectHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

class MavenITExtension
implements BeforeEachCallback,
ParameterResolver,
BeforeTestExecutionCallback,
InvocationInterceptor {
    private static final List<String> DEFAULT_COMMAND_LINE_OPTIONS = Arrays.asList("--batch-mode", "-V", "--errors");

    MavenITExtension() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new ExtensionConfigurationException("MavenITExtension is only supported for classes."));
        boolean resourcesIts = AnnotationHelper.findMavenProjectSourcesAnnotation(context).map(s -> s.resourcesUsage().equals((Object)MavenProjectSources.ResourceUsage.DEFAULT)).orElse(true);
        Path targetTestClassesDirectory = DirectoryHelper.getTargetDir().resolve("maven-it");
        String toFullyQualifiedPath = DirectoryHelper.toFullyQualifiedPath(testClass);
        Path mavenItTestCaseBaseDirectory = targetTestClassesDirectory.resolve(toFullyQualifiedPath);
        Files.createDirectories(mavenItTestCaseBaseDirectory, new FileAttribute[0]);
        StorageHelper storageHelper = new StorageHelper(context);
        storageHelper.save(targetTestClassesDirectory, mavenItTestCaseBaseDirectory, DirectoryHelper.getTargetDir());
        Optional<Class<?>> mavenProject = AnnotationHelper.findMavenProjectAnnotation(context);
        DirectoryResolverResult directoryResolverResult = new DirectoryResolverResult(context);
        Path integrationTestCaseDirectory = directoryResolverResult.getIntegrationTestCaseDirectory();
        MavenProjectResult mavenProjectResult = new MavenProjectResult(directoryResolverResult.getTargetDirectory(), directoryResolverResult.getProjectDirectory(), directoryResolverResult.getIntegrationTestCaseDirectory(), new Model());
        storageHelper.put((Object)((Object)ParameterType.ProjectResult) + context.getUniqueId(), mavenProjectResult);
        Files.createDirectories(integrationTestCaseDirectory, new FileAttribute[0]);
        if (mavenProject.isPresent()) {
            if (!Files.exists(directoryResolverResult.getProjectDirectory(), new LinkOption[0])) {
                Files.createDirectories(directoryResolverResult.getProjectDirectory(), new FileAttribute[0]);
                Files.createDirectories(directoryResolverResult.getCacheDirectory(), new FileAttribute[0]);
                PathUtils.copyDirectoryRecursively(directoryResolverResult.getSourceMavenProject(), directoryResolverResult.getProjectDirectory());
                PathUtils.copyDirectoryRecursively(directoryResolverResult.getTargetItfRepoDirectory(), directoryResolverResult.getCacheDirectory());
            }
        } else {
            PathUtils.deleteRecursively(directoryResolverResult.getProjectDirectory());
            Files.createDirectories(directoryResolverResult.getProjectDirectory(), new FileAttribute[0]);
            Files.createDirectories(directoryResolverResult.getCacheDirectory(), new FileAttribute[0]);
            if (!resourcesIts) {
                return;
            }
            PathUtils.copyDirectoryRecursively(directoryResolverResult.getSourceMavenProject(), directoryResolverResult.getProjectDirectory());
            PathUtils.copyDirectoryRecursively(directoryResolverResult.getTargetItfRepoDirectory(), directoryResolverResult.getCacheDirectory());
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return Stream.of(ParameterType.values()).anyMatch(parameterType -> parameterType.getKlass() == parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        StorageHelper sh = new StorageHelper(extensionContext);
        ParameterType parameterType = Stream.of(ParameterType.values()).filter(s -> s.getKlass() == parameterContext.getParameter().getType()).findFirst().orElseThrow(() -> new IllegalStateException("Unknown parameter type"));
        return sh.get((Object)((Object)parameterType) + extensionContext.getUniqueId(), parameterType.getKlass());
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        invocation.proceed();
    }

    private Optional<String> getSystemPATH() {
        return Optional.ofNullable(System.getenv("PATH"));
    }

    public void beforeTestExecution(ExtensionContext context) throws IOException, InterruptedException {
        Object collect;
        Method methodName = (Method)context.getTestMethod().orElseThrow(() -> new IllegalStateException("No method given"));
        String prefix = "mvn";
        Optional<Class<?>> mavenProject = AnnotationHelper.findMavenProjectAnnotation(context);
        if (mavenProject.isPresent()) {
            prefix = methodName.getName() + "-mvn";
        }
        DirectoryResolverResult directoryResolverResult = new DirectoryResolverResult(context);
        Path integrationTestCaseDirectory = directoryResolverResult.getIntegrationTestCaseDirectory();
        Files.createDirectories(integrationTestCaseDirectory, new FileAttribute[0]);
        Optional<Path> predefinedRepository = directoryResolverResult.getPredefinedRepository();
        if (predefinedRepository.isPresent()) {
            PathUtils.copyDirectoryRecursively(predefinedRepository.get(), directoryResolverResult.getCacheDirectory());
        } else {
            boolean annotationPresent = methodName.isAnnotationPresent(MavenPredefinedRepository.class);
            if (annotationPresent) {
                MavenPredefinedRepository annotation = methodName.getAnnotation(MavenPredefinedRepository.class);
                Path predefinedRepoPath = directoryResolverResult.getSourceMavenProject().resolve(annotation.value());
                PathUtils.copyDirectoryRecursively(predefinedRepoPath, directoryResolverResult.getCacheDirectory());
            }
        }
        Optional<Path> mvnLocation = new MavenLocator(FileSystems.getDefault(), this.getSystemPATH(), OS.WINDOWS.isCurrentOs()).findMvn();
        if (!mvnLocation.isPresent()) {
            throw new IllegalStateException("We could not find the maven executable `mvn` somewhere");
        }
        Path projectWorkingDirectory = directoryResolverResult.getProjectDirectory();
        Optional<MavenProjectLocation> mavenProjectLocationContext = AnnotationHelper.findMavenProjectLocationAnnotation(context);
        if (mavenProjectLocationContext.isPresent()) {
            String mavenProjectLocation = mavenProjectLocationContext.get().value();
            if (mavenProjectLocation.isEmpty()) {
                throw new IllegalStateException("You have to define a location in your MavenProjectLocation annotation");
            }
            projectWorkingDirectory = directoryResolverResult.getProjectDirectory().resolve(mavenProjectLocation);
        }
        ApplicationExecutor mavenExecutor = new ApplicationExecutor(projectWorkingDirectory, integrationTestCaseDirectory, mvnLocation.get(), Collections.emptyList(), prefix);
        ArrayList<String> executionArguments = new ArrayList<String>();
        List<String> defaultArguments = Arrays.asList("-Dmaven.repo.local=" + directoryResolverResult.getCacheDirectory().toString());
        executionArguments.addAll(defaultArguments);
        if (AnnotationHelper.hasProfiles(context)) {
            collect = AnnotationHelper.profiles(context).stream().collect(Collectors.joining(",", "-P", ""));
            executionArguments.add((String)collect);
        }
        if (AnnotationHelper.hasSystemProperties(context)) {
            collect = AnnotationHelper.systemProperties(context).stream().map(s -> s.content().isEmpty() ? "-D" + s.value() : "-D" + s.value() + "=" + s.content()).collect(Collectors.toList());
            executionArguments.addAll((Collection<String>)collect);
        }
        if (AnnotationHelper.hasOptions(context)) {
            executionArguments.addAll(AnnotationHelper.options(context));
        } else {
            executionArguments.addAll(DEFAULT_COMMAND_LINE_OPTIONS);
        }
        if (AnnotationHelper.hasGoals(context)) {
            List<String> resultingGoals = AnnotationHelper.goals(context);
            Map<String, String> keyValues = this.pomEntries(directoryResolverResult);
            List<String> filteredGoals = new PropertiesFilter(keyValues, resultingGoals).filter();
            executionArguments.addAll(filteredGoals);
        } else {
            executionArguments.add("package");
        }
        Process start = mavenExecutor.start(executionArguments);
        int processCompletableFuture = start.waitFor();
        MavenExecutionResult.ExecutionResult executionResult = MavenExecutionResult.ExecutionResult.Successful;
        if (processCompletableFuture != 0) {
            executionResult = MavenExecutionResult.ExecutionResult.Failure;
        }
        MavenLog log = new MavenLog(mavenExecutor.getStdout(), mavenExecutor.getStdErr());
        MavenCacheResult mavenCacheResult = new MavenCacheResult(directoryResolverResult.getCacheDirectory());
        Model model = ProjectHelper.readProject((Path)projectWorkingDirectory.resolve("pom.xml"));
        MavenProjectResult mavenProjectResult = new MavenProjectResult(directoryResolverResult.getIntegrationTestCaseDirectory(), directoryResolverResult.getProjectDirectory(), directoryResolverResult.getCacheDirectory(), model);
        MavenExecutionResult result = new MavenExecutionResult(executionResult, processCompletableFuture, log, mavenProjectResult, mavenCacheResult);
        new StorageHelper(context).save(result, log, mavenCacheResult, mavenProjectResult);
    }

    private Map<String, String> pomEntries(DirectoryResolverResult directoryResolverResult) {
        Path mavenBaseDirectory = directoryResolverResult.getTargetDirectory().getParent();
        Path pomFile = mavenBaseDirectory.resolve("pom.xml");
        ModelReader modelReader = new ModelReader(ProjectHelper.readProject((Path)pomFile));
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("project.groupId", modelReader.getGroupId());
        keyValues.put("project.artifactId", modelReader.getArtifactId());
        keyValues.put("project.version", modelReader.getVersion());
        return keyValues;
    }
}

