/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Pattern;

class MavenLocator {
    private static final String MAVEN_HOME = "maven.home";
    private static final String ITF_DEBUG = "ITF_DEBUG";
    private final FileSystem fileSystem;
    private final Optional<String> pathEnvironment;
    private final boolean isRunningOnWindows;
    private final String mvnExecutable;

    MavenLocator(FileSystem fileSystem, Optional<String> pathEnvironment, boolean isRunningOnWindows) {
        this.fileSystem = fileSystem;
        this.pathEnvironment = pathEnvironment;
        this.isRunningOnWindows = isRunningOnWindows;
        this.mvnExecutable = Boolean.getBoolean(ITF_DEBUG) ? "mvnDebug" : "mvn";
    }

    private Path intoPath(String s) {
        return this.fileSystem.getPath(s, new String[0]);
    }

    private Path intoBin(Path p) {
        return p.resolve("bin");
    }

    private Optional<String> mavenHomeFromSystemProperty() {
        return Optional.ofNullable(System.getProperty(MAVEN_HOME));
    }

    private Path toMvn(Path p) {
        return p.resolve(this.mvnExecutable);
    }

    private Path toBat(Path p) {
        return p.resolve(this.mvnExecutable + ".bat");
    }

    private Path toCmd(Path p) {
        return p.resolve(this.mvnExecutable + ".cmd");
    }

    private boolean isExecutable(Path s) {
        return Files.isRegularFile(s, new LinkOption[0]) && Files.isReadable(s) && Files.isExecutable(s);
    }

    private Optional<Path> executableNonWindows(Path s) {
        return Optional.of(this.toMvn(s)).filter(this::isExecutable);
    }

    private Optional<Path> executableWindows(Path s) {
        Path mvnBat = this.toBat(s);
        if (this.isExecutable(mvnBat)) {
            return Optional.of(mvnBat);
        }
        Path mvnCmd = this.toCmd(s);
        if (this.isExecutable(mvnCmd)) {
            return Optional.of(mvnCmd);
        }
        return Optional.empty();
    }

    private Optional<Path> executable(Path p) {
        if (this.isRunningOnWindows) {
            return this.executableWindows(p);
        }
        return this.executableNonWindows(p);
    }

    private Optional<Path> checkExecutableViaPathEnvironment() {
        if (!this.pathEnvironment.isPresent()) {
            return Optional.empty();
        }
        String pathSeparator = this.isRunningOnWindows ? ";" : ":";
        Pattern pathSeparatorPattern = Pattern.compile(Pattern.quote(pathSeparator));
        return pathSeparatorPattern.splitAsStream(this.pathEnvironment.get()).map(this::intoPath).map(this::executable).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    Optional<Path> findMvn() {
        Optional<Path> path = this.mavenHomeFromSystemProperty().map(this::intoPath).map(this::intoBin).flatMap(this::executable);
        if (path.isPresent()) {
            return path;
        }
        return this.checkExecutableViaPathEnvironment();
    }
}

