/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.MavenVersionComparator;
import com.soebes.itf.jupiter.extension.MavenVersionParser;
import com.soebes.itf.jupiter.extension.Preconditions;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public enum MavenVersion {
    UNKNOWN(MavenVersionComparator.of()),
    ANY(MavenVersionComparator.of()),
    M3_0(MavenVersionComparator.of(3, 0)),
    M3_0_5(MavenVersionComparator.of(3, 0, 5)),
    M3_1(MavenVersionComparator.of(3, 1)),
    M3_1_0(MavenVersionComparator.of(3, 1, 0)),
    M3_1_1(MavenVersionComparator.of(3, 1, 1)),
    M3_2(MavenVersionComparator.of(3, 2)),
    M3_2_1(MavenVersionComparator.of(3, 2, 1)),
    M3_2_2(MavenVersionComparator.of(3, 2, 2)),
    M3_2_3(MavenVersionComparator.of(3, 2, 3)),
    M3_2_5(MavenVersionComparator.of(3, 2, 5)),
    M3_3(MavenVersionComparator.of(3, 3)),
    M3_3_1(MavenVersionComparator.of(3, 3, 1)),
    M3_3_3(MavenVersionComparator.of(3, 3, 3)),
    M3_3_9(MavenVersionComparator.of(3, 3, 9)),
    M3_5(MavenVersionComparator.of(3, 5)),
    M3_5_0(MavenVersionComparator.of(3, 5, 0)),
    M3_5_2(MavenVersionComparator.of(3, 5, 2)),
    M3_5_3(MavenVersionComparator.of(3, 5, 3)),
    M3_5_4(MavenVersionComparator.of(3, 5, 4)),
    M3_6(MavenVersionComparator.of(3, 6)),
    M3_6_0(MavenVersionComparator.of(3, 6, 0)),
    M3_6_1(MavenVersionComparator.of(3, 6, 1)),
    M3_6_2(MavenVersionComparator.of(3, 6, 2)),
    M3_6_3(MavenVersionComparator.of(3, 6, 3)),
    M3_8(MavenVersionComparator.of(3, 8)),
    M3_8_1(MavenVersionComparator.of(3, 8, 1)),
    M3_8_2(MavenVersionComparator.of(3, 8, 2)),
    M3_8_3(MavenVersionComparator.of(3, 8, 3)),
    M3_8_4(MavenVersionComparator.of(3, 8, 4)),
    M3_8_5(MavenVersionComparator.of(3, 8, 5)),
    M3_8_6(MavenVersionComparator.of(3, 8, 6)),
    M3_8_7(MavenVersionComparator.of(3, 8, 7)),
    M3_8_8(MavenVersionComparator.of(3, 8, 8)),
    M3_9(MavenVersionComparator.of(3, 9)),
    M3_9_0(MavenVersionComparator.of(3, 9, 0)),
    M3_9_1(MavenVersionComparator.of(3, 9, 1)),
    M3_9_2(MavenVersionComparator.of(3, 9, 2)),
    M3_9_3(MavenVersionComparator.of(3, 9, 3)),
    M3_9_4(MavenVersionComparator.of(3, 9, 4)),
    M3_9_5(MavenVersionComparator.of(3, 9, 5)),
    M3_9_6(MavenVersionComparator.of(3, 9, 6)),
    M4_0(MavenVersionComparator.of(4, 0)),
    M4_0_0(MavenVersionComparator.of(4, 0, 0)),
    M4_0_1(MavenVersionComparator.of(4, 0, 1));

    private static final MavenVersionComparator CURRENT_MAVEN_VERSION;
    private final MavenVersionComparator versionComparator;

    private MavenVersion(MavenVersionComparator versionComparator) {
        this.versionComparator = versionComparator;
    }

    private static MavenVersionComparator determineCurrentVersion() {
        String currentVersion = Preconditions.requireNotNull(System.getProperty("maven.version"), "JVM system property 'maven.version' is empty.");
        Preconditions.requireNotEmpty(currentVersion, "JVM system property 'maven.version' is empty. The maven version can not being detected.");
        return MavenVersionParser.parseVersion(currentVersion);
    }

    public boolean isCurrentVersion() {
        return this.getVersion().compareTo(CURRENT_MAVEN_VERSION) == 0;
    }

    public MavenVersionComparator getVersion() {
        return this.versionComparator;
    }

    static {
        CURRENT_MAVEN_VERSION = MavenVersion.determineCurrentVersion();
    }
}

