/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.MavenITExtension;
import com.soebes.itf.jupiter.extension.ParameterType;
import com.soebes.itf.jupiter.extension.Storage;
import com.soebes.itf.jupiter.maven.MavenCacheResult;
import com.soebes.itf.jupiter.maven.MavenExecutionResult;
import com.soebes.itf.jupiter.maven.MavenLog;
import com.soebes.itf.jupiter.maven.MavenProjectResult;
import java.nio.file.Path;
import org.junit.jupiter.api.extension.ExtensionContext;

final class StorageHelper {
    private static final ExtensionContext.Namespace NAMESPACE_MAVEN_IT = ExtensionContext.Namespace.create((Object[])new Object[]{MavenITExtension.class});
    private final ExtensionContext.Store nameSpace;
    private final ExtensionContext context;

    StorageHelper(ExtensionContext context) {
        this.nameSpace = context.getStore(NAMESPACE_MAVEN_IT);
        this.context = context;
    }

    <V> V get(Storage storage, Class<V> requiredType) {
        return (V)this.nameSpace.get((Object)storage, requiredType);
    }

    <V> V get(Object key, Class<V> requiredType) {
        return (V)this.nameSpace.get(key, requiredType);
    }

    void put(Object key, Object value) {
        this.nameSpace.put(key, value);
    }

    void save(Path targetTestClassesDirectory, Path mavenItTestCaseBaseDirectory, Path targetDirectory) {
        StorageHelper sh = new StorageHelper(this.context);
        sh.put((Object)Storage.TARGET_MAVEN_IT_DIRECTORY, targetTestClassesDirectory);
        sh.put((Object)Storage.MAVEN_IT_TESTCASE_BASEDIRECTORY, mavenItTestCaseBaseDirectory);
        sh.put((Object)Storage.TARGET_DIRECTORY, targetDirectory);
    }

    void save(MavenExecutionResult result, MavenLog log, MavenCacheResult mavenCacheResult, MavenProjectResult mavenProjectResult) {
        this.put((Object)((Object)ParameterType.ExecutionResult) + this.context.getUniqueId(), result);
        this.put((Object)((Object)ParameterType.LogResult) + this.context.getUniqueId(), log);
        this.put((Object)((Object)ParameterType.CacheResult) + this.context.getUniqueId(), mavenCacheResult);
        this.put((Object)((Object)ParameterType.ProjectResult) + this.context.getUniqueId(), mavenProjectResult);
    }
}

