/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.okhttp;

import java.io.InputStream;
import java.io.Serializable;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Route;
import okhttp3.internal.http.HttpMethod;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.capabilities.package;
import sttp.client4.Backend;
import sttp.client4.BackendOptions;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.Response;
import sttp.client4.ResponseAsDelegate;
import sttp.client4.SttpClientException$;
import sttp.client4.compression.CompressionHandlers;
import sttp.client4.compression.Compressor$;
import sttp.client4.compression.Decompressor$;
import sttp.client4.internal.FailingLimitedInputStream;
import sttp.client4.internal.OnEndInputStream;
import sttp.client4.okhttp.BodyFromOkHttp;
import sttp.client4.okhttp.BodyToOkHttp;
import sttp.client4.okhttp.OkHttpBackend$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.Method$;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode$;
import sttp.ws.WebSocket;

@ScalaSignature(bytes="\u0006\u0005\t-g!\u0002\u0010 \u0003\u00031\u0003\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006A\u0002!\t!\u0019\u0005\bw\u0002\u0011\rQ\"\u0001}\u000b\u0011i\b\u0001\u0001@\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u00111\u0006\u0001\u0007\u0012\u00055\u0002bBA\u001f\u0001\u0019E\u0011q\b\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011!\ti\b\u0001C\u0001?\u0005}\u0004\"CAI\u0001\t\u0007i\u0011CAJ\u0011%\tY\n\u0001b\u0001\u000e#\ti\n\u0003\u0005\u0002&\u0002!\taHAT\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\u0004\u00011\tB!\u0002\b\u000f\t}q\u0004#\u0001\u0003\"\u00191ad\bE\u0001\u0005GAa\u0001Y\n\u0005\u0002\t\u0015\u0002\"\u0003B\u0014'\t\u0007I\u0011\u0001B\u0015\u0011!\u00119d\u0005Q\u0001\n\t-bA\u0002B\u001d'\u0011\u0011Y\u0004\u0003\u0006\u0003P]\u0011\t\u0011)A\u0005\u0005#Ba\u0001Y\f\u0005\u0002\t}\u0003b\u0002B4/\u0011\u0005#\u0011\u000e\u0005\t\u0005s\u001aB\u0011A\u0010\u0003|!A!\u0011S\n\u0005\u0002}\u0011\u0019\n\u0003\u0005\u0003(N!\ta\bBU\u00055y5\u000e\u0013;ua\n\u000b7m[3oI*\u0011\u0001%I\u0001\u0007_.DG\u000f\u001e9\u000b\u0005\t\u001a\u0013aB2mS\u0016tG\u000f\u000e\u0006\u0002I\u0005!1\u000f\u001e;q\u0007\u0001)Ba\n\u001bf\u0003N!\u0001\u0001\u000b\u0018D!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB!q\u0006\r\u001aA\u001b\u0005\t\u0013BA\u0019\"\u000599UM\\3sS\u000e\u0014\u0015mY6f]\u0012\u0004\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\t\ta)\u0006\u00028}E\u0011\u0001h\u000f\t\u0003SeJ!A\u000f\u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0006P\u0005\u0003{)\u00121!\u00118z\t\u0015yDG1\u00018\u0005\u0011yF\u0005J\u0019\u0011\u0005M\nE!\u0002\"\u0001\u0005\u00049$!\u0001)\u0011\u0007=\"%'\u0003\u0002FC\t9!)Y2lK:$\u0017AB2mS\u0016tG\u000f\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u001dy7\u000e\u001b;uaNJ!\u0001T%\u0003\u0019=[\u0007\n\u001e;q\u00072LWM\u001c;\u0002\u0017\rdwn]3DY&,g\u000e\u001e\t\u0003S=K!\u0001\u0015\u0016\u0003\u000f\t{w\u000e\\3b]\u0006\u00192m\\7qe\u0016\u001c8/[8o\u0011\u0006tG\r\\3sgB!1K\u0016!Y\u001b\u0005!&BA+\"\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\n\u0005]#&aE\"p[B\u0014Xm]:j_:D\u0015M\u001c3mKJ\u001c\bCA-_\u001b\u0005Q&BA.]\u0003\tIwNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&aC%oaV$8\u000b\u001e:fC6\fa\u0001P5oSRtD\u0003\u00022ysj\u0004Ra\u0019\u00013I\u0002k\u0011a\b\t\u0003g\u0015$QA\u001a\u0001C\u0002\u001d\u0014\u0011aU\t\u0003q!\u00042![;e\u001d\tQ'O\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011a.J\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!!]\u0012\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\n\u0005M$\u0018a\u00029bG.\fw-\u001a\u0006\u0003c\u000eJ!A^<\u0003\u000fM#(/Z1ng*\u00111\u000f\u001e\u0005\u0006\r\u0012\u0001\ra\u0012\u0005\u0006\u001b\u0012\u0001\rA\u0014\u0005\u0006#\u0012\u0001\rAU\u0001\bgR\u0014X-Y7t+\u0005A'!\u0001*\u0013\t}\u0004\u00151\u0001\u0004\u0006\u0003\u0003\u0001\u0001A \u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0005S\u0006\u0015!'C\u0002\u0002\b]\u0014a!\u00124gK\u000e$\u0018\u0001B:f]\u0012,B!!\u0004\u0002\u001aQ!\u0011qBA\u000f!\u0011\u0019D'!\u0005\u0011\u000b=\n\u0019\"a\u0006\n\u0007\u0005U\u0011E\u0001\u0005SKN\u0004xN\\:f!\r\u0019\u0014\u0011\u0004\u0003\u0007\u000379!\u0019A\u001c\u0003\u0003QCq!a\b\b\u0001\u0004\t\t#A\u0004sKF,Xm\u001d;\u0011\u000f=\n\u0019#a\u0006\u0002(%\u0019\u0011QE\u0011\u0003\u001d\u001d+g.\u001a:jGJ+\u0017/^3tiB\u0019\u0011\u0011\u0006\u0004\u000e\u0003\u0001\t1b]3oIJ+w-\u001e7beV!\u0011qFA\u001c)\u0011\t\t$!\u000f\u0011\tM\"\u00141\u0007\t\u0006_\u0005M\u0011Q\u0007\t\u0004g\u0005]BABA\u000e\u0011\t\u0007q\u0007C\u0004\u0002 !\u0001\r!a\u000f\u0011\u000f=\n\u0019#!\u000e\u0002(\u0005i1/\u001a8e/\u0016\u00147k\\2lKR,B!!\u0011\u0002JQ!\u00111IA&!\u0011\u0019D'!\u0012\u0011\u000b=\n\u0019\"a\u0012\u0011\u0007M\nI\u0005\u0002\u0004\u0002\u001c%\u0011\ra\u000e\u0005\b\u0003?I\u0001\u0019AA'!\u001dy\u00131EA$\u0003O\t\u0001#\u00193kkN$X\t_2faRLwN\\:\u0016\t\u0005M\u00131\f\u000b\u0007\u0003+\n9'a\u001b\u0015\t\u0005]\u0013Q\f\t\u0005gQ\nI\u0006E\u00024\u00037\"a!a\u0007\u000b\u0005\u00049\u0004\u0002CA0\u0015\u0011\u0005\r!!\u0019\u0002\u0003Q\u0004R!KA2\u0003/J1!!\u001a+\u0005!a$-\u001f8b[\u0016t\u0004BBA5\u0015\u0001\u0007a*A\u0006jg^+'m]8dW\u0016$\bbBA\u0010\u0015\u0001\u0007\u0011Q\u000e\u0019\u0007\u0003_\n\u0019(!\u001f\u0011\u000f=\n\u0019#!\u001d\u0002xA\u00191'a\u001d\u0005\u0017\u0005U\u00141NA\u0001\u0002\u0003\u0015\ta\u000e\u0002\u0004?\u0012\n\u0004cA\u001a\u0002z\u0011Y\u00111PA6\u0003\u0003\u0005\tQ!\u00018\u0005\ryFEM\u0001\u000fG>tg/\u001a:u%\u0016\fX/Z:u+\u0011\t\t)a$\u0015\t\u0005\r\u0015\u0011\u0012\t\u0004\u0011\u0006\u0015\u0015bAAD\u0013\n9!+Z9vKN$\bbBA\u0010\u0017\u0001\u0007\u00111\u0012\t\b_\u0005\r\u0012QRA\u0014!\r\u0019\u0014q\u0012\u0003\u0007\u00037Y!\u0019A\u001c\u0002\u0019\t|G-\u001f+p\u001f.DE\u000f\u001e9\u0016\u0005\u0005U\u0005#B2\u0002\u0018J\"\u0017bAAM?\ta!i\u001c3z)>|5\u000e\u0013;ua\u0006q!m\u001c3z\rJ|WnT6IiR\u0004XCAAP!\u0015\u0019\u0017\u0011\u0015\u001ae\u0013\r\t\u0019k\b\u0002\u000f\u0005>$\u0017P\u0012:p[>[\u0007\n\u001e;q\u00031\u0011X-\u00193SKN\u0004xN\\:f+\u0011\tI+!-\u0015\u0015\u0005-\u00161WA^\u0003\u000f\f\t\u000e\u0005\u00034i\u00055\u0006#B\u0018\u0002\u0014\u0005=\u0006cA\u001a\u00022\u00121\u00111\u0004\bC\u0002]Bq!!.\u000f\u0001\u0004\t9,A\u0002sKN\u00042\u0001SA]\u0013\r\t)\"\u0013\u0005\b\u0003?q\u0001\u0019AA_a\u0011\ty,a1\u0011\u000f=\n\u0019#!1\u0002(A\u00191'a1\u0005\u0017\u0005\u0015\u00171XA\u0001\u0002\u0003\u0015\ta\u000e\u0002\u0004?\u0012\u001a\u0004bBAe\u001d\u0001\u0007\u00111Z\u0001\u000be\u0016\u001c\bo\u001c8tK\u0006\u001b\bcB\u0018\u0002N\u0006=\u0016qE\u0005\u0004\u0003\u001f\f#A\u0005*fgB|gn]3Bg\u0012+G.Z4bi\u0016Da!a5\u000f\u0001\u0004q\u0015aC5t/\u0016\u00147k\\2lKR\f1B]3bI\"+\u0017\rZ3sgR!\u0011\u0011\\A{!\u0019\tY.a9\u0002j:!\u0011Q\\Aq\u001d\ra\u0017q\\\u0005\u0002W%\u00111OK\u0005\u0005\u0003K\f9O\u0001\u0003MSN$(BA:+!\u0011\tY/!=\u000e\u0005\u00055(bAAxG\u0005)Qn\u001c3fY&!\u00111_Aw\u0005\u0019AU-\u00193fe\"9\u0011QW\bA\u0002\u0005]\u0016!B2m_N,GCAA~!\u0011\u0019D'!@\u0011\u0007%\ny0C\u0002\u0003\u0002)\u0012A!\u00168ji\u0006\t2M]3bi\u0016\u001c\u0016.\u001c9mKF+X-^3\u0016\t\t\u001d!QD\u000b\u0003\u0005\u0013\u0001Ba\r\u001b\u0003\fA9!Q\u0002B\fe\tmQB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\u0005]\u001c(b\u0001B\u000bC\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0003\u001a\t=!aC*j[BdW-U;fk\u0016\u00042a\rB\u000f\t\u0019\tY\"\u0005b\u0001o\u0005iqj\u001b%uiB\u0014\u0015mY6f]\u0012\u0004\"aY\n\u0014\u0005MACC\u0001B\u0011\u0003y!UMZ1vYR<VMY*pG.,GOQ;gM\u0016\u00148)\u00199bG&$\u00180\u0006\u0002\u0003,A)\u0011F!\f\u00032%\u0019!q\u0006\u0016\u0003\r=\u0003H/[8o!\rI#1G\u0005\u0004\u0005kQ#aA%oi\u0006yB)\u001a4bk2$x+\u001a2T_\u000e\\W\r\u001e\"vM\u001a,'oQ1qC\u000eLG/\u001f\u0011\u0003%A\u0013x\u000e_=BkRDWM\u001c;jG\u0006$xN]\n\u0006/\tu\"\u0011\n\t\u0005\u0005\u007f\u0011)%\u0004\u0002\u0003B)\u0019!1\t/\u0002\t1\fgnZ\u0005\u0005\u0005\u000f\u0012\tE\u0001\u0004PE*,7\r\u001e\t\u0004\u0011\n-\u0013b\u0001B'\u0013\ni\u0011)\u001e;iK:$\u0018nY1u_J\fA!Y;uQB!!1\u000bB-\u001d\ry#QK\u0005\u0004\u0005/\n\u0013A\u0004\"bG.,g\u000eZ(qi&|gn]\u0005\u0005\u00057\u0012iFA\u0005Qe>D\u00180Q;uQ*\u0019!qK\u0011\u0015\t\t\u0005$Q\r\t\u0004\u0005G:R\"A\n\t\u000f\t=\u0013\u00041\u0001\u0003R\u0005a\u0011-\u001e;iK:$\u0018nY1uKR1\u00111\u0011B6\u0005kBqA!\u001c\u001b\u0001\u0004\u0011y'A\u0003s_V$X\rE\u0002I\u0005cJ1Aa\u001dJ\u0005\u0015\u0011v.\u001e;f\u0011\u001d\u00119H\u0007a\u0001\u0003o\u000b\u0001B]3ta>t7/Z\u0001\u000eI\u00164\u0017-\u001e7u\u00072LWM\u001c;\u0015\u000b\u001d\u0013iHa\"\t\u000f\t}4\u00041\u0001\u0003\u0002\u0006Y!/Z1e)&lWm\\;u!\rI#1Q\u0005\u0004\u0005\u000bS#\u0001\u0002'p]\u001eDqA!#\u001c\u0001\u0004\u0011Y)A\u0004paRLwN\\:\u0011\u0007=\u0012i)C\u0002\u0003\u0010\u0006\u0012aBQ1dW\u0016tGm\u00149uS>t7/A\u0010va\u0012\fG/Z\"mS\u0016tG/\u00134DkN$x.\u001c*fC\u0012$\u0016.\\3pkR,bA!&\u0003 \n\rF#B$\u0003\u0018\n\u0015\u0006b\u0002BM9\u0001\u0007!1T\u0001\u0002eB9q&a\t\u0003\u001e\n\u0005\u0006cA\u001a\u0003 \u00121\u00111\u0004\u000fC\u0002]\u00022a\rBR\t\u00151GD1\u00018\u0011\u00151E\u00041\u0001H\u0003y)\u0007pY3qi&|g\u000eV8TiR\u00048\t\\5f]R,\u0005pY3qi&|g\u000e\u0006\u0005\u0003,\nM&Q\u0017Bd!\u0015I#Q\u0006BW!\u0011\tYNa,\n\t\tE\u0016q\u001d\u0002\n\u000bb\u001cW\r\u001d;j_:Da!!\u001b\u001e\u0001\u0004q\u0005bBA\u0010;\u0001\u0007!q\u0017\u0019\u0007\u0005s\u0013iLa1\u0011\u000f=\n\u0019Ca/\u0003BB\u00191G!0\u0005\u0017\t}&QWA\u0001\u0002\u0003\u0015\ta\u000e\u0002\u0004?\u0012\"\u0004cA\u001a\u0003D\u0012Y!Q\u0019B[\u0003\u0003\u0005\tQ!\u00018\u0005\ryF%\u000e\u0005\b\u0005\u0013l\u0002\u0019\u0001BW\u0003\u0005)\u0007")
public abstract class OkHttpBackend<F, S extends package.Streams<S>, P>
implements Backend<F> {
    private final OkHttpClient client;
    private final boolean closeClient;
    private final CompressionHandlers<P, InputStream> compressionHandlers;

    public static Option<Object> DefaultWebSocketBufferCapacity() {
        return OkHttpBackend$.MODULE$.DefaultWebSocketBufferCapacity();
    }

    public abstract package.Streams<S> streams();

    public <T> F send(GenericRequest<T, P> request) {
        return this.adjustExceptions(request.isWebSocket(), request, (Function0 & Serializable)() -> {
            if (request.isWebSocket()) {
                return this.sendWebSocket(request);
            }
            return this.sendRegular(request);
        });
    }

    public abstract <T> F sendRegular(GenericRequest<T, P> var1);

    public abstract <T> F sendWebSocket(GenericRequest<T, P> var1);

    private <T> F adjustExceptions(boolean isWebsocket, GenericRequest<?, ?> request, Function0<F> t) {
        return (F)SttpClientException$.MODULE$.adjustExceptions(this.monad(), t, (Function1 & Serializable)x$1 -> OkHttpBackend$.MODULE$.exceptionToSttpClientException(isWebsocket, request, (Exception)x$1));
    }

    public <T> Request convertRequest(GenericRequest<T, P> request) {
        Request.Builder builder = new Request.Builder().url(request.uri().toString());
        Tuple2 tuple2 = Compressor$.MODULE$.compressIfNeeded(request, this.compressionHandlers.compressors());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GenericRequestBody maybeCompressedBody = (GenericRequestBody)tuple2._1();
        Option contentLength = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maybeCompressedBody, (Object)contentLength);
        GenericRequestBody maybeCompressedBody2 = (GenericRequestBody)tuple22._1();
        Option contentLength2 = (Option)tuple22._2();
        Option<RequestBody> body = this.bodyToOkHttp().apply(maybeCompressedBody2, (Option<String>)request.contentType(), (Option<Object>)contentLength2);
        builder.method(request.method(), (RequestBody)body.getOrElse((Function0 & Serializable)() -> {
            if (HttpMethod.requiresRequestBody((String)request.method())) {
                return RequestBody.create((String)"", null);
            }
            return null;
        }));
        request.headers().foreach((Function1 & Serializable)header -> {
            OkHttpBackend.$anonfun$convertRequest$2(builder, header);
            return BoxedUnit.UNIT;
        });
        contentLength2.foreach((Function1 & Serializable)cl -> builder.addHeader(HeaderNames$.MODULE$.ContentLength(), Long.toString(BoxesRunTime.unboxToLong((Object)cl))));
        return builder.build();
    }

    public abstract BodyToOkHttp<F, S> bodyToOkHttp();

    public abstract BodyFromOkHttp<F, S> bodyFromOkHttp();

    public <T> F readResponse(okhttp3.Response res, GenericRequest<?, P> request, ResponseAsDelegate<T, P> responseAs, boolean isWebSocket) {
        List<Header> headers = this.readHeaders(res);
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply(StatusCode$.MODULE$.apply(res.code()), res.message(), headers);
        Option encoding = headers.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Header, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.is(HeaderNames$.MODULE$.ContentEncoding())) {
                    return (B1)A1.value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Header x1) {
                Header header = x1;
                return header.is(HeaderNames$.MODULE$.ContentEncoding());
            }
        });
        String method = res.request().method();
        InputStream inputStream = res.body().byteStream();
        InputStream limitedInputStream = (InputStream)request.maxResponseBodyLength().fold((Function0 & Serializable)() -> inputStream, (Function1 & Serializable)l -> OkHttpBackend.$anonfun$readResponse$2(inputStream, BoxesRunTime.unboxToLong((Object)l)));
        String string = method;
        String string2 = Method$.MODULE$.HEAD();
        InputStream decompressedInputStream = (string == null ? string2 != null : !string.equals(string2)) && !((Object)BoxesRunTime.boxToInteger((int)res.code())).equals(BoxesRunTime.boxToInteger((int)StatusCode$.MODULE$.NoContent())) && request.autoDecompressionEnabled() ? (InputStream)encoding.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty())).map((Function1 & Serializable)e -> (InputStream)Decompressor$.MODULE$.decompressIfPossible((Object)limitedInputStream, e, $this.compressionHandlers.decompressors())).getOrElse((Function0 & Serializable)() -> limitedInputStream) : limitedInputStream;
        InputStream inputStreamWithCallback = isWebSocket ? decompressedInputStream : new OnEndInputStream(decompressedInputStream, (Function0)(JFunction0.mcV.sp & Serializable)() -> request.options().onBodyReceived().apply((Object)responseMetadata));
        F body = this.bodyFromOkHttp().apply(inputStreamWithCallback, responseAs, responseMetadata, (Option<WebSocket<F>>)None$.MODULE$);
        return (F)this.monad().map(body, (Function1 & Serializable)x$5 -> new Response(x$5, StatusCode$.MODULE$.apply(res.code()), res.message(), (Seq)headers, (List)Nil$.MODULE$, request.onlyMetadata()));
    }

    private List<Header> readHeaders(okhttp3.Response res) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(res.headers().names()).asScala()).flatMap((Function1 & Serializable)name -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(res.headers().values(name)).asScala()).map((Function1 & Serializable)x$6 -> Header$.MODULE$.apply(name, x$6)))).toList();
    }

    public F close() {
        if (this.closeClient) {
            return (F)this.monad().eval((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.client.dispatcher().executorService().shutdown());
        }
        return (F)this.monad().unit((Object)BoxedUnit.UNIT);
    }

    public abstract <T> F createSimpleQueue();

    public static final /* synthetic */ void $anonfun$convertRequest$2(Request.Builder builder$1, Header header) {
        if (!header.is(HeaderNames$.MODULE$.ContentLength())) {
            Request.Builder builder = builder$1.addHeader(header.name(), header.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public static final /* synthetic */ FailingLimitedInputStream $anonfun$readResponse$2(InputStream inputStream$1, long l) {
        return new FailingLimitedInputStream(inputStream$1, l);
    }

    public OkHttpBackend(OkHttpClient client, boolean closeClient, CompressionHandlers<P, InputStream> compressionHandlers) {
        this.client = client;
        this.closeClient = closeClient;
        this.compressionHandlers = compressionHandlers;
    }

    private static class ProxyAuthenticator
    implements Authenticator {
        private final BackendOptions.ProxyAuth auth;

        public Request authenticate(Route route, okhttp3.Response response) {
            String credential = Credentials.basic((String)this.auth.username(), (String)this.auth.password());
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        }

        public ProxyAuthenticator(BackendOptions.ProxyAuth auth) {
            this.auth = auth;
        }
    }
}

