/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.PublisherConfigurationProvider;
import com.solace.messaging.config.provider.PublisherPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class PublisherAckConfigurationProvider
implements PublisherConfigurationProvider {
    private final Properties configurationSource = new Properties();

    private PublisherAckConfigurationProvider() {
    }

    public static PublisherAckConfigurationProvider deliveryAckTimeout(int timeout) {
        Validation.outOfRangeIllegal(20, 60000, timeout, "Publisher ack timeout can't be outside of 20-60000 range");
        PublisherAckConfigurationProvider provider = new PublisherAckConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.service.publishers.persistent.ack-timeout", String.valueOf(timeout));
        return provider;
    }

    public static PublisherAckConfigurationProvider deliveryAckWindowSize(int windowSize) {
        Validation.outOfRangeIllegal(1, 255, windowSize, "Window size can't be outside of 1-255 range");
        PublisherAckConfigurationProvider provider = new PublisherAckConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.service.publishers.persistent.ack-window-size", String.valueOf(windowSize));
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return PublisherPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

