/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.Message;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.util.Converter;
import com.solace.messaging.util.internal.Internal;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.io.Serializable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface InboundMessage
extends Message {
    public boolean isRedelivered();

    public MessageDiscardNotification getMessageDiscardNotification();

    public <T extends Serializable> T getAndConvertPayload(Converter.BytesToObject<T> var1, Class<T> var2) throws PubSubPlusClientException.IncompatibleMessageException;

    public String getDestinationName();

    public long getTimeStamp();

    public boolean isCached();

    public ReplicationGroupMessageId getReplicationGroupMessageId();

    public int getClassOfService();

    public String dump();

    public Long getSenderTimestamp();

    public String getSenderId();

    @Internal
    @ProviderType
    public static abstract class SolaceMessageListener
    implements XMLMessageListener {
        private final String name;

        protected SolaceMessageListener(String name) {
            this.name = name;
        }

        public void onReceive(BytesXMLMessage message) {
            if (message != null) {
                try {
                    this.onReceive(MessageReceiver.InboundMessageImpl.toInboundMessage(message));
                }
                catch (PubSubPlusClientException e) {
                    this.onException(e);
                }
            } else {
                this.onException(new PubSubPlusClientException("null message received"));
            }
        }

        public void onException(JCSMPException exception) {
            this.onException(new PubSubPlusClientException(exception));
        }

        public abstract void onException(PubSubPlusClientException var1);

        public abstract void onReceive(InboundMessage var1);
    }

    @FunctionalInterface
    public static interface IncompatibleMessageHandler {
        public void onIncompatibleMessage(InboundMessage var1, Converter.BytesToObject var2, Class<?> var3, PubSubPlusClientException.IncompatibleMessageException var4);
    }

    @Internal
    @ProviderType
    public static interface AcknowledgmentSupport
    extends Serializable {
        public long getAckMessageId();
    }

    @ProviderType
    public static interface MessageDiscardNotification
    extends Serializable {
        public boolean hasBrokerDiscardIndication();

        public boolean hasInternalDiscardIndication();
    }

    @ProviderType
    public static interface ReplicationGroupMessageId
    extends Serializable {
        public static ReplicationGroupMessageId of(String replicationGroupMessageIdString) throws IllegalArgumentException {
            return MessageReceiver.InboundMessageImpl.ReplicationGroupMessageIdImpl.create(replicationGroupMessageIdString);
        }

        public int compare(ReplicationGroupMessageId var1) throws IllegalArgumentException;

        public String toString();
    }
}

