/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util;

import com.solace.messaging.publisher.MessagePublisher;
import com.solace.messaging.publisher.PublisherBuffers;
import com.solace.messaging.publisher.PublisherHealthCheck;
import com.solace.messaging.util.async.ThreadFactories;
import com.solace.messaging.util.internal.Internal;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class PublisherCongestionNotificationDispatcher
implements PublisherBuffers.BufferCongestionMonitor {
    private static final Log logger = LogFactory.getLog(PublisherCongestionNotificationDispatcher.class);
    private volatile PublisherHealthCheck.PublisherReadinessListener readinessListener;
    private final MessagePublisher messagePublisher;
    private final ExecutorService bufferCongestionNotificationExecutorService;

    public PublisherCongestionNotificationDispatcher(MessagePublisher messagePublisher) {
        this.messagePublisher = messagePublisher;
        this.bufferCongestionNotificationExecutorService = Executors.newSingleThreadExecutor(new ThreadFactories.NamedDaemonThreadFactory(this.messagePublisher.publisherInfo().getInstanceName() + "-buffer-congestion-dispatcher"));
    }

    public final void notifyWhenReady() {
        block9: {
            if (!this.bufferCongestionNotificationExecutorService.isShutdown() && this.readinessListener != null) {
                ScheduledPublisherCongestionReleaseNotification notification = new ScheduledPublisherCongestionReleaseNotification();
                try {
                    Future<Void> f = this.bufferCongestionNotificationExecutorService.submit(notification);
                    if (f == null && logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification"));
                    }
                    break block9;
                }
                catch (RejectedExecutionException ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification; processing notification on a dispatcher thread"));
                    }
                    try {
                        notification.call();
                        break block9;
                    }
                    catch (Exception exc) {
                        logger.debug((Object)"Exception by customer callback during PublisherReadinessListener notification processing", (Throwable)exc);
                    }
                }
                catch (Exception ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification"));
                    }
                    break block9;
                }
            }
            logger.debug((Object)"Skip notification on a PublisherReadinessListener, listener is not set or notification dispatcher is closed");
        }
    }

    @Override
    public final boolean isActive() {
        return this.readinessListener != null;
    }

    public final void close() {
        this.readinessListener = null;
        if (!this.bufferCongestionNotificationExecutorService.isShutdown()) {
            this.bufferCongestionNotificationExecutorService.shutdown();
        }
    }

    public final void setPublisherReadinessListener(PublisherHealthCheck.PublisherReadinessListener readinessListener) {
        this.readinessListener = readinessListener;
    }

    @Override
    public final void onCongestionRelease(int remainingCapacity) {
        block9: {
            if (this.readinessListener != null && !this.bufferCongestionNotificationExecutorService.isShutdown()) {
                ScheduledPublisherCongestionReleaseNotification notification = new ScheduledPublisherCongestionReleaseNotification();
                try {
                    Future<Void> f = this.bufferCongestionNotificationExecutorService.submit(notification);
                    if (f == null && logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification"));
                    }
                    break block9;
                }
                catch (RejectedExecutionException ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification; processing notification on a dispatcher thread"));
                    }
                    try {
                        notification.call();
                        break block9;
                    }
                    catch (Exception exc) {
                        logger.debug((Object)"Exception by customer callback during PublisherReadinessListener notification processing", (Throwable)exc);
                    }
                }
                catch (Exception ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(this.messagePublisher.publisherInfo().getInstanceName() + " could not schedule PublisherReadinessListener notification"));
                    }
                    break block9;
                }
            }
            logger.debug((Object)"Skip notification on a PublisherReadinessListener, listener is not set or notification dispatcher is closed");
        }
    }

    @Internal
    @ProviderType
    private class ScheduledPublisherCongestionReleaseNotification
    implements Callable<Void> {
        ScheduledPublisherCongestionReleaseNotification() {
        }

        @Override
        public Void call() {
            PublisherHealthCheck.PublisherReadinessListener l = PublisherCongestionNotificationDispatcher.this.readinessListener;
            if (l == null) {
                logger.warn((Object)"Skip notification on a PublisherReadinessListener, listener is not set");
                return null;
            }
            try {
                if (PublisherCongestionNotificationDispatcher.this.messagePublisher != null && PublisherCongestionNotificationDispatcher.this.messagePublisher.isReady()) {
                    l.ready();
                } else {
                    logger.debug((Object)"Skip notification on a PublisherReadinessListener, publisher is not ready");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Client code in PublisherReadinessListener:ready() thrown an exception", (Throwable)e);
            }
            return null;
        }
    }
}

