/*
 * Decompiled with CFR 0.152.
 */
package com.springml.sftp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private String algorithm;
    private String key;

    public CryptoUtils(String key, String algorithm) {
        this.key = key;
        this.algorithm = algorithm;
    }

    public void encrypt(File inputFile, File outputFile) throws Exception {
        this.doCrypto(1, inputFile, outputFile);
    }

    public void decrypt(File inputFile, File outputFile) throws Exception {
        this.doCrypto(2, inputFile, outputFile);
    }

    private void doCrypto(int cipherMode, File inputFile, File outputFile) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(inputFile);
             FileOutputStream outputStream = new FileOutputStream(outputFile);){
            SecretKeySpec secretKey = new SecretKeySpec(this.key.getBytes(), this.algorithm);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(cipherMode, secretKey);
            byte[] inputBytes = new byte[(int)inputFile.length()];
            inputStream.read(inputBytes);
            byte[] outputBytes = cipher.doFinal(inputBytes);
            outputStream.write(outputBytes);
            inputStream.close();
            outputStream.close();
        }
    }
}

