/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.BalanceStrategy;
import com.sproutsocial.nsq.BasePubSub;
import com.sproutsocial.nsq.Client;
import com.sproutsocial.nsq.ConnectionDetails;
import com.sproutsocial.nsq.NSQException;
import com.sproutsocial.nsq.PubConnection;
import com.sproutsocial.nsq.Publisher;
import com.sproutsocial.nsq.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBasedBalanceStrategy
extends BasePubSub
implements BalanceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ListBasedBalanceStrategy.class);
    protected final List<ConnectionDetails> daemonList;
    private final Publisher parent;
    private final Function<List<ConnectionDetails>, ConnectionDetails> connectionDetailsSelector;
    private int failoverDurationSecs = 300;

    public static BiFunction<Client, Publisher, BalanceStrategy> getRoundRobinStrategyBuilder(List<String> nsqd) {
        return (c, p) -> ListBasedBalanceStrategy.buildRoundRobinStrategy(c, p, nsqd);
    }

    public static BiFunction<Client, Publisher, BalanceStrategy> getFailoverStrategyBuilder(List<String> nsqd) {
        return (c, p) -> ListBasedBalanceStrategy.buildFailoverStrategy(c, p, nsqd);
    }

    private static ListBasedBalanceStrategy buildRoundRobinStrategy(Client client, Publisher parent, List<String> nsqd) {
        return new ListBasedBalanceStrategy(client, parent, nsqd, new Function<List<ConnectionDetails>, ConnectionDetails>(){
            private int nextDaemonIndex = 0;

            @Override
            public ConnectionDetails apply(List<ConnectionDetails> daemonList) {
                for (int attempts = 0; attempts < daemonList.size(); ++attempts) {
                    ConnectionDetails candidate = daemonList.get(this.nextDaemonIndex);
                    boolean candidateReady = candidate.makeReady();
                    ++this.nextDaemonIndex;
                    if (this.nextDaemonIndex >= daemonList.size()) {
                        this.nextDaemonIndex = 0;
                    }
                    if (!candidateReady) continue;
                    return candidate;
                }
                ListBasedBalanceStrategy.clearAllConnections(daemonList);
                throw new NSQException("publish failed: Unable to establish a connection with any NSQ host: " + daemonList);
            }
        });
    }

    private static ListBasedBalanceStrategy buildFailoverStrategy(Client client, Publisher parent, List<String> nsqd) {
        return new ListBasedBalanceStrategy(client, parent, nsqd, daemonList -> {
            for (int attempts = 0; attempts < daemonList.size(); ++attempts) {
                ConnectionDetails candidate = (ConnectionDetails)daemonList.get(attempts);
                if (!candidate.makeReady()) continue;
                return candidate;
            }
            ListBasedBalanceStrategy.clearAllConnections(daemonList);
            throw new NSQException("publish failed: Unable to establish a connection with any NSQ host: " + daemonList);
        });
    }

    private static void clearAllConnections(List<ConnectionDetails> daemonList) {
        for (ConnectionDetails daemon : daemonList) {
            daemon.clearConnection();
        }
    }

    public ListBasedBalanceStrategy(Client client, Publisher parent, List<String> nsqd, Function<List<ConnectionDetails>, ConnectionDetails> connectionDetailsSelector) {
        super(client);
        Util.checkNotNull(parent);
        Util.checkNotNull(nsqd);
        Util.checkNotNull(connectionDetailsSelector);
        this.parent = parent;
        this.connectionDetailsSelector = connectionDetailsSelector;
        ArrayList<ConnectionDetails> connectionDetails = new ArrayList<ConnectionDetails>();
        for (String host : nsqd) {
            if (host == null) continue;
            connectionDetails.add(new ConnectionDetails(host, this.parent, this.failoverDurationSecs, this));
        }
        this.daemonList = Collections.unmodifiableList(connectionDetails);
    }

    @Override
    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetailsSelector.apply(this.daemonList);
    }

    @Override
    public synchronized void connectionClosed(PubConnection closedCon) {
        for (ConnectionDetails daemon : this.daemonList) {
            if (daemon.getCon() != closedCon) continue;
            daemon.clearConnection();
            logger.debug("removed closed publisher connection:{}", (Object)closedCon.getHost());
        }
    }

    @Override
    public int getFailoverDurationSecs() {
        return this.failoverDurationSecs;
    }

    @Override
    public void setFailoverDurationSecs(int failoverDurationSecs) {
        this.failoverDurationSecs = failoverDurationSecs;
        for (ConnectionDetails connectionDetails : this.daemonList) {
            connectionDetails.setFailoverDurationSecs(failoverDurationSecs);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{daemonList=" + this.daemonList + ", failoverDurationSecs=" + this.failoverDurationSecs + '}';
    }
}

