/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.BalanceStrategy;
import com.sproutsocial.nsq.BasePubSub;
import com.sproutsocial.nsq.Client;
import com.sproutsocial.nsq.ConnectionDetails;
import com.sproutsocial.nsq.NSQException;
import com.sproutsocial.nsq.PubConnection;
import com.sproutsocial.nsq.Publisher;
import com.sproutsocial.nsq.Util;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleNsqdBalanceStrategy
extends BasePubSub
implements BalanceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SingleNsqdBalanceStrategy.class);
    protected final ConnectionDetails connectionDetails;
    private int failoverDurationSecs = 10;

    public SingleNsqdBalanceStrategy(Client client, Publisher parent, String nsqd) {
        super(client);
        logger.warn("You are configured to use a singe NSQD balance strategy.  This has both availability and correctness issues.  Nsq-j is sleeping for failover duration on a failed publish inside a critical lock section impacting all threads calling to publish.  This may appear to be lock starvation. The client is also not resilient to failures in this mode, a single outage can result in dataloss and crashing (slowly).  Please use failover or round robin balance strategy to avoid these issues");
        this.connectionDetails = new ConnectionDetails(nsqd, parent, this.failoverDurationSecs, this);
    }

    @Override
    public ConnectionDetails getConnectionDetails() {
        if (!this.connectionDetails.makeReady()) {
            logger.warn("We aren't able to connect just now, so we are going to sleep for {} seconds", (Object)this.failoverDurationSecs);
            Util.sleepQuietly(TimeUnit.SECONDS.toMillis(this.failoverDurationSecs));
            if (this.connectionDetails.makeReady()) {
                return this.connectionDetails;
            }
            throw new NSQException("Unable to connect");
        }
        return this.connectionDetails;
    }

    @Override
    public synchronized void connectionClosed(PubConnection closedCon) {
        if (this.connectionDetails.getCon() == closedCon) {
            this.connectionDetails.clearConnection();
            logger.debug("removed closed publisher connection:{}", (Object)closedCon.getHost());
        }
    }

    @Override
    public int getFailoverDurationSecs() {
        return this.failoverDurationSecs;
    }

    @Override
    public void setFailoverDurationSecs(int failoverDurationSecs) {
        this.failoverDurationSecs = failoverDurationSecs;
        this.connectionDetails.setFailoverDurationSecs(failoverDurationSecs);
    }

    public String toString() {
        return "SingleNsqdBallenceStrategy{daemon=" + this.connectionDetails + ", failoverDurationSecs=" + this.failoverDurationSecs + '}';
    }
}

