/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.animation;

import android.animation.Keyframe;
import android.animation.TimeInterpolator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.ObjectAssert;

public class KeyframeAssert
extends AbstractAssert<KeyframeAssert, Keyframe> {
    public KeyframeAssert(Keyframe actual) {
        super((Object)actual, KeyframeAssert.class);
    }

    public KeyframeAssert hasFraction(float fraction) {
        this.isNotNull();
        float actualFraction = ((Keyframe)this.actual).getFraction();
        ((FloatAssert)Assertions.assertThat((float)actualFraction).overridingErrorMessage("Expected fraction <%s> but was <%s>.", new Object[]{Float.valueOf(fraction), Float.valueOf(actualFraction)})).isEqualTo(fraction);
        return this;
    }

    public KeyframeAssert hasInterpolator(TimeInterpolator interpolator) {
        this.isNotNull();
        TimeInterpolator actualInterpolator = ((Keyframe)this.actual).getInterpolator();
        ((ObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return this;
    }

    public KeyframeAssert hasType(Class type) {
        this.isNotNull();
        Class actualType = ((Keyframe)this.actual).getType();
        ((ObjectAssert)Assertions.assertThat((Object)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo((Object)type);
        return this;
    }

    public KeyframeAssert hasValue(Object value) {
        this.isNotNull();
        Object actualValue = ((Keyframe)this.actual).getValue();
        ((ObjectAssert)Assertions.assertThat((Object)actualValue).overridingErrorMessage("Expected value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }
}

