/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.app;

import android.app.ActionBar;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.util.BitMaskStringBuilder;

public class ActionBarAssert
extends AbstractAssert<ActionBarAssert, ActionBar> {
    public ActionBarAssert(ActionBar actual) {
        super((Object)actual, ActionBarAssert.class);
    }

    public ActionBarAssert hasCustomView() {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((ActionBar)this.actual).getCustomView()).overridingErrorMessage("Expected custom view but was not present.", new Object[0])).isNotNull();
        return this;
    }

    public ActionBarAssert hasDisplayOptions(int options) {
        this.isNotNull();
        int actualOptions = ((ActionBar)this.actual).getDisplayOptions();
        ((IntegerAssert)Assertions.assertThat((int)actualOptions).overridingErrorMessage("Expected display options <%s> but was <%s>.", new Object[]{ActionBarAssert.displayOptionsToString(options), ActionBarAssert.displayOptionsToString(actualOptions)})).isEqualTo(options);
        return this;
    }

    public ActionBarAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((ActionBar)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public ActionBarAssert hasNavigationItemCount(int count) {
        this.isNotNull();
        int actualCount = ((ActionBar)this.actual).getNavigationItemCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public ActionBarAssert hasNavigationMode(int mode) {
        this.isNotNull();
        int actualMode = ((ActionBar)this.actual).getNavigationMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected mode <%s> but was <%s>.", new Object[]{ActionBarAssert.navigationModeToString(mode), ActionBarAssert.navigationModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public ActionBarAssert hasSelectedNavigationIndex(int index) {
        this.isNotNull();
        int actualIndex = ((ActionBar)this.actual).getSelectedNavigationIndex();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected selected index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public ActionBarAssert hasSubtitle(CharSequence subtitle) {
        this.isNotNull();
        CharSequence actualSubtitle = ((ActionBar)this.actual).getSubtitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualSubtitle).overridingErrorMessage("Expected subtitle <%s> but was <%s>.", new Object[]{subtitle, actualSubtitle})).isEqualTo((Object)subtitle);
        return this;
    }

    public ActionBarAssert hasSubtitle(int resId) {
        return this.hasSubtitle(((ActionBar)this.actual).getThemedContext().getString(resId));
    }

    public ActionBarAssert hasTabCount(int count) {
        this.isNotNull();
        int actualCount = ((ActionBar)this.actual).getTabCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected tab count of <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public ActionBarAssert hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((ActionBar)this.actual).getTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public ActionBarAssert hasTitle(int resId) {
        return this.hasTitle(((ActionBar)this.actual).getThemedContext().getString(resId));
    }

    public ActionBarAssert isShowing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionBar)this.actual).isShowing()).overridingErrorMessage("Expected to be showing but was not showing.", new Object[0])).isTrue();
        return this;
    }

    public ActionBarAssert isNotShowing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionBar)this.actual).isShowing()).overridingErrorMessage("Expected to be not showing but was showing.", new Object[0])).isFalse();
        return this;
    }

    private static String navigationModeToString(int mode) {
        switch (mode) {
            case 1: {
                return "list";
            }
            case 0: {
                return "standard";
            }
            case 2: {
                return "tabs";
            }
        }
        throw new IllegalArgumentException("Unknown navigation mode: " + mode);
    }

    private static String displayOptionsToString(int options) {
        return new BitMaskStringBuilder(options).flag(4, "homeAsUp").flag(16, "showCustom").flag(2, "showHome").flag(8, "showTitle").flag(1, "useLogo").get();
    }
}

