/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.BitmapRegionDecoder;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public class BitmapRegionDecoderAssert
extends AbstractAssert<BitmapRegionDecoderAssert, BitmapRegionDecoder> {
    public BitmapRegionDecoderAssert(BitmapRegionDecoder actual) {
        super((Object)actual, BitmapRegionDecoderAssert.class);
    }

    public BitmapRegionDecoderAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((BitmapRegionDecoder)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public BitmapRegionDecoderAssert hasWidth(int width) {
        this.isNotNull();
        int actualHeight = ((BitmapRegionDecoder)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }

    public BitmapRegionDecoderAssert isRecycled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((BitmapRegionDecoder)this.actual).isRecycled()).overridingErrorMessage("Expected to be recycled but was not recycled.", new Object[0])).isTrue();
        return this;
    }

    public BitmapRegionDecoderAssert isNotRecycled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((BitmapRegionDecoder)this.actual).isRecycled()).overridingErrorMessage("Expected to not be recycled but was recycled.", new Object[0])).isFalse();
        return this;
    }
}

