/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.hardware;

import android.hardware.Sensor;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.StringAssert;

public class SensorAssert
extends AbstractAssert<SensorAssert, Sensor> {
    public SensorAssert(Sensor actual) {
        super((Object)actual, SensorAssert.class);
    }

    public SensorAssert hasMaximumRange(float range) {
        this.isNotNull();
        float actualRange = ((Sensor)this.actual).getMaximumRange();
        ((FloatAssert)Assertions.assertThat((float)actualRange).overridingErrorMessage("Expected maximum range <%s> but was <%s>.", new Object[]{Float.valueOf(range), Float.valueOf(actualRange)})).isEqualTo(range);
        return this;
    }

    public SensorAssert hasMinDelay(int delay) {
        this.isNotNull();
        int actualDelay = ((Sensor)this.actual).getMinDelay();
        ((IntegerAssert)Assertions.assertThat((int)actualDelay).overridingErrorMessage("Expected minimum delay <%s> but was <%s>.", new Object[]{delay, actualDelay})).isEqualTo(delay);
        return this;
    }

    public SensorAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((Sensor)this.actual).getName();
        ((StringAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public SensorAssert hasPower(float power) {
        this.isNotNull();
        float actualPower = ((Sensor)this.actual).getPower();
        ((FloatAssert)Assertions.assertThat((float)actualPower).overridingErrorMessage("Expected power <%s> but was <%s>.", new Object[]{Float.valueOf(power), Float.valueOf(actualPower)})).isEqualTo(power);
        return this;
    }

    public SensorAssert hasResolution(float resolution) {
        this.isNotNull();
        float actualResolution = ((Sensor)this.actual).getResolution();
        ((FloatAssert)Assertions.assertThat((float)actualResolution).overridingErrorMessage("Expected resolution <%s> but was <%s>.", new Object[]{Float.valueOf(resolution), Float.valueOf(actualResolution)})).isEqualTo(resolution);
        return this;
    }

    public SensorAssert hasType(int type) {
        this.isNotNull();
        int actualType = ((Sensor)this.actual).getType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    public SensorAssert hasVendor(String vendor) {
        this.isNotNull();
        String actualVendor = ((Sensor)this.actual).getVendor();
        ((StringAssert)Assertions.assertThat((String)actualVendor).overridingErrorMessage("Expected vendor <%s> but was <%s>.", new Object[]{vendor, actualVendor})).isEqualTo((Object)vendor);
        return this;
    }

    public SensorAssert hasVersion(int version) {
        this.isNotNull();
        int actualVersion = ((Sensor)this.actual).getVersion();
        ((IntegerAssert)Assertions.assertThat((int)actualVersion).overridingErrorMessage("Expected version <%s> but was <%s>.", new Object[]{version, actualVersion})).isEqualTo(version);
        return this;
    }
}

