//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Address](index.md)

# Address

[jvm]\
class [Address](index.md)(uriHost: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), uriPort: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), val dns: [Dns](../-dns/index.md), val socketFactory: [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html), val sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html)?, val hostnameVerifier: [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html)?, val certificatePinner: [CertificatePinner](../-certificate-pinner/index.md)?, val proxyAuthenticator: [Authenticator](../-authenticator/index.md), val proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)?, protocols: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;, connectionSpecs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](../-connection-spec/index.md)&gt;, val proxySelector: [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html))

A specification for a connection to an origin server. For simple connections, this is the server's hostname and port. If an explicit proxy is requested (or [no proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html#NO_PROXY--) is explicitly requested), this also includes that proxy information. For secure connections the address also includes the SSL socket factory, hostname verifier, and certificate pinner.

HTTP requests that share the same [Address](index.md) may also share the same [Connection](../-connection/index.md).

## Constructors

| | |
|---|---|
| [Address](-address.md) | [jvm]<br>fun [Address](-address.md)(uriHost: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), uriPort: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), dns: [Dns](../-dns/index.md), socketFactory: [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html), sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html)?, hostnameVerifier: [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html)?, certificatePinner: [CertificatePinner](../-certificate-pinner/index.md)?, proxyAuthenticator: [Authenticator](../-authenticator/index.md), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)?, protocols: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;, connectionSpecs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](../-connection-spec/index.md)&gt;, proxySelector: [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html)) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [certificatePinner](certificate-pinner.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;certificatePinner&quot;)<br>val [certificatePinner](certificate-pinner.md): [CertificatePinner](../-certificate-pinner/index.md)?<br>Returns this address's certificate pinner, or null if this is not an HTTPS address. |
| [connectionSpecs](connection-specs.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;connectionSpecs&quot;)<br>val [connectionSpecs](connection-specs.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](../-connection-spec/index.md)&gt; |
| [dns](dns.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;dns&quot;)<br>val [dns](dns.md): [Dns](../-dns/index.md)<br>Returns the service that will be used to resolve IP addresses for hostnames. |
| [hostnameVerifier](hostname-verifier.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;hostnameVerifier&quot;)<br>val [hostnameVerifier](hostname-verifier.md): [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html)?<br>Returns the hostname verifier, or null if this is not an HTTPS address. |
| [protocols](protocols.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;protocols&quot;)<br>val [protocols](protocols.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;<br>The protocols the client supports. This method always returns a non-null list that contains minimally Protocol.HTTP_1_1. |
| [proxy](proxy.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxy&quot;)<br>val [proxy](proxy.md): [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)?<br>Returns this address's explicitly-specified HTTP proxy, or null to delegate to the [proxy selector](proxy-selector.md). |
| [proxyAuthenticator](proxy-authenticator.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxyAuthenticator&quot;)<br>val [proxyAuthenticator](proxy-authenticator.md): [Authenticator](../-authenticator/index.md)<br>Returns the client's proxy authenticator. |
| [proxySelector](proxy-selector.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxySelector&quot;)<br>val [proxySelector](proxy-selector.md): [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html)<br>Returns this address's proxy selector. Only used if the proxy is null. If none of this selector's proxies are reachable, a direct connection will be attempted. |
| [socketFactory](socket-factory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;socketFactory&quot;)<br>val [socketFactory](socket-factory.md): [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html)<br>Returns the socket factory for new connections. |
| [sslSocketFactory](ssl-socket-factory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;sslSocketFactory&quot;)<br>val [sslSocketFactory](ssl-socket-factory.md): [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html)?<br>Returns the SSL socket factory, or null if this is not an HTTPS address. |
| [url](url.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;url&quot;)<br>val [url](url.md): [HttpUrl](../-http-url/index.md)<br>Returns a URL with the hostname and port of the origin server. The path, query, and fragment of this URL are always empty, since they are not significant for planning a route. |
